% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasummary_correlation.R
\name{datasummary_correlation_format}
\alias{datasummary_correlation_format}
\title{Format the content of a correlation table}
\usage{
datasummary_correlation_format(
  x,
  fmt,
  leading_zero = FALSE,
  diagonal = NULL,
  upper_triangle = NULL
)
}
\arguments{
\item{x}{square numeric matrix}

\item{fmt}{determines how to format numeric values
\itemize{
\item integer: the number of digits to keep after the period \code{format(round(x, fmt), nsmall=fmt)}
\item character: passed to the \code{sprintf} function (e.g., '\%.3f' keeps 3 digits with trailing zero). See \code{?sprintf}
\item function: returns a formatted character string.
\item NULL: does not format numbers, which allows users to include function in the "glue" strings in the \code{estimate} and \code{statistic} arguments.
}}

\item{leading_zero}{boolean. If \code{FALSE}, leading zeros are removed}

\item{diagonal}{character or NULL. If character, all elements of the
diagonal are replaced by the same character (e.g., "1").}

\item{upper_triangle}{character or NULL. If character, all elements of the
upper triangle are replaced by the same character (e.g., "" or ".").}
}
\description{
Mostly for internal use, but can be useful when users supply a function to
the \code{method} argument of \code{datasummary_correlation}.
}
\examples{
library(modelsummary)

dat <- mtcars[, c("mpg", "hp", "disp")]

cor_fun <- function(x) {
  out <- cor(x, method = "kendall")
  datasummary_correlation_format(
    out,
    fmt = 2,
    upper_triangle = "x",
    diagonal = ".")
}

datasummary_correlation(dat, method = cor_fun)
}
