% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers_math.R
\name{softmax.modello_number}
\alias{softmax.modello_number}
\alias{softmax.numeric}
\alias{softmax.matrix}
\alias{softmax}
\title{Number Softmax}
\usage{
\method{softmax}{modello_number}(x, k = 0)

\method{softmax}{numeric}(x, k = 0)

\method{softmax}{matrix}(x, k = 0)

softmax(x, k)
}
\arguments{
\item{x}{a 'numeric' or a reference object of class 'number'}

\item{k}{dimension index. Currently constained to be <= 2}
}
\value{
Returns a 'numeric' or reference object of class 'number'
}
\description{
Calculates the Softmax function
\deqn{sofmax = \frac{exp(\bf x)}{\sum{exp(\bf x)}}}
}
\examples{
modello.init()
## For modello_number matrices
x = number(matrix(rnorm(9), 3, 3))
y1 = softmax(x)
print(y1)
print(y1$v)
y2 = softmax(x, 1)
print(y2)
print(y2$v)
y3 = softmax(x, 2)
print(y3)
print(y3$v)
modello.close()
## For numerics
x = rnorm(5)
y = softmax(x)
print(y)
## For matrices
x = matrix(rnorm(9), 3, 3)
y1 = softmax(x)
print(y1)
y2 = softmax(x, 1)
print(y2)
y3 = softmax(x, 2)
print(y3)
}
\author{
Filippo Monari
}
