% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers_math.R
\name{ldbeta.modello_number}
\alias{ldbeta.modello_number}
\alias{ldbeta.default}
\alias{ldbeta}
\title{Beta Distribution: log-density}
\usage{
\method{ldbeta}{modello_number}(y, a1, a2)

\method{ldbeta}{default}(y, a1, a2)

ldbeta(y, a1, a2)
}
\arguments{
\item{y}{observations, numeric or reference object of class 'number'}

\item{a1}{shape parameter, numeric of reference object of class 'number'}

\item{a2}{shape parameter, numeric of reference object of class 'number'}
}
\value{
Returns a 'numeric' or a reference object of class 'number'
}
\description{
Considering a Beta Distribution calculates the log-density
\deqn{ld = (\alpha_1 - 1) * log(y) + (\alpha_2 - 1) * log(1 - y) - logBeta(\alpha_1, \alpha_2); y \in (0, 1)}
}
\examples{
modello.init()
## For modello_numbers
y = number(rbeta(10, 1, 2))
ld = ldbeta(y, .k(1), .k(2))
print(ld)
print(ld$v)
modello.close()
## For numerics
y = rbeta(10, 1, 2)
ld = ldbeta(y, 1, 2)
print(ld) 
}
\author{
Filippo Monari
}
