% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{.modello.session}
\alias{.modello.session}
\title{R6 class representing the current modello session}
\description{
R6 class representing the current modello session

R6 class representing the current modello session
}
\details{
An object of this class called '.modello' is created when
the package is loaded and will do the booking keeping of
what happens during the session.
}
\author{
Filippo Monari
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.init}}{stores the init status of the session (TRUE/FALSE)}

\item{\code{.n.numbers}}{number of allocate slot for storing \code{number}}

\item{\code{.numbers}}{environment keeping track of the created \code{numbers}}

\item{\code{.n.nodes}}{number of slot allocated for storing \code{nodes}}

\item{\code{.n.graphs}}{number of slots allocated for storing \code{graphs}}

\item{\code{.graphs}}{environement keeping track of the created \code{graphs}}

\item{\code{.n.opts}}{number of slots allocated for storing \code{optimisers}}

\item{\code{.opts}}{environment keeping track of the created \code{optimisers}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{.modello.session$new()}}
\item \href{#method-init}{\code{.modello.session$init()}}
\item \href{#method-close}{\code{.modello.session$close()}}
\item \href{#method-reset}{\code{.modello.session$reset()}}
\item \href{#method-finalize}{\code{.modello.session$finalize()}}
\item \href{#method-next.name}{\code{.modello.session$next.name()}}
\item \href{#method-new.number}{\code{.modello.session$new.number()}}
\item \href{#method-number.name.exists}{\code{.modello.session$number.name.exists()}}
\item \href{#method-append.number}{\code{.modello.session$append.number()}}
\item \href{#method-get.number}{\code{.modello.session$get.number()}}
\item \href{#method-pop.number}{\code{.modello.session$pop.number()}}
\item \href{#method-number.id}{\code{.modello.session$number.id()}}
\item \href{#method-number.exists}{\code{.modello.session$number.exists()}}
\item \href{#method-number.gc}{\code{.modello.session$number.gc()}}
\item \href{#method-apply.math_op}{\code{.modello.session$apply.math_op()}}
\item \href{#method-new.graph}{\code{.modello.session$new.graph()}}
\item \href{#method-graph.name.exists}{\code{.modello.session$graph.name.exists()}}
\item \href{#method-graph.open}{\code{.modello.session$graph.open()}}
\item \href{#method-get.graph}{\code{.modello.session$get.graph()}}
\item \href{#method-pop.graph}{\code{.modello.session$pop.graph()}}
\item \href{#method-graph.id}{\code{.modello.session$graph.id()}}
\item \href{#method-graph.exists}{\code{.modello.session$graph.exists()}}
\item \href{#method-graph.gc}{\code{.modello.session$graph.gc()}}
\item \href{#method-new.opt}{\code{.modello.session$new.opt()}}
\item \href{#method-opt.name.exists}{\code{.modello.session$opt.name.exists()}}
\item \href{#method-append.opt}{\code{.modello.session$append.opt()}}
\item \href{#method-get.opt}{\code{.modello.session$get.opt()}}
\item \href{#method-pop.opt}{\code{.modello.session$pop.opt()}}
\item \href{#method-opt.id}{\code{.modello.session$opt.id()}}
\item \href{#method-opt.exists}{\code{.modello.session$opt.exists()}}
\item \href{#method-clone}{\code{.modello.session$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
modello session object initialisation method.
It does nothgin, it is just use on package load
to create the .modello object containing the session.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-init"></a>}}
\if{latex}{\out{\hypertarget{method-init}{}}}
\subsection{Method \code{init()}}{
Allocates all the arrays necessary to the session
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$init(n.numbers, n.nodes, n.graphs, n.opts)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n.numbers}}{number of \code{numbers}}

\item{\code{n.nodes}}{number of \code{nodes}}

\item{\code{n.graphs}}{number of \code{graphs}}

\item{\code{n.opts}}{number of \code{optimisers}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns invisible NULL.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-close"></a>}}
\if{latex}{\out{\hypertarget{method-close}{}}}
\subsection{Method \code{close()}}{
Deallocates all the session arrays
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$close()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns invisible NULL.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset"></a>}}
\if{latex}{\out{\hypertarget{method-reset}{}}}
\subsection{Method \code{reset()}}{
Reset the session by deallocating and reallocating all the arrays.
The data in the arrays is lost.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$reset()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns invisible NULL.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
Closes the session if its object is destroyed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-next.name"></a>}}
\if{latex}{\out{\hypertarget{method-next.name}{}}}
\subsection{Method \code{next.name()}}{
build unique random number ideintifying a \code{number},
\code{graph} or \code{optimizer}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$next.name(typ)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{typ}}{charcter indicating the type of object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new.number"></a>}}
\if{latex}{\out{\hypertarget{method-new.number}{}}}
\subsection{Method \code{new.number()}}{
Creates a new \code{number} and return the corresponding
reference object of class 'number'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$new.number(id, name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{number} id}

\item{\code{name}}{\code{number} name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-number.name.exists"></a>}}
\if{latex}{\out{\hypertarget{method-number.name.exists}{}}}
\subsection{Method \code{number.name.exists()}}{
Checks if a \code{number} name exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$number.name.exists(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\code{number} name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns TRUE if the name exists, FALSE otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-append.number"></a>}}
\if{latex}{\out{\hypertarget{method-append.number}{}}}
\subsection{Method \code{append.number()}}{
Append a \code{number} of the given shape to the
\code{NUMBER_} array. A link to the \code{number}
is create the \code{numbers} environment within the
session object. This method is called each time
a new \code{number} is created.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$append.number(shp, dx, name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{shp}}{\code{number} shape}

\item{\code{dx}}{if TRUE allocate a derivative array for the \code{number}}

\item{\code{name}}{character, \code{number} name. Only for loading saved \code{numbers}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns an object of class 'number' referring
to the appended \code{number}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get.number"></a>}}
\if{latex}{\out{\hypertarget{method-get.number}{}}}
\subsection{Method \code{get.number()}}{
Given a name (character identifier) for a \code{number}
creates and returns a reference objects of class 'number'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$get.number(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\code{number} name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a object of class 'number'
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pop.number"></a>}}
\if{latex}{\out{\hypertarget{method-pop.number}{}}}
\subsection{Method \code{pop.number()}}{
Pops (removes) a \code{number} fro the \code{NUMBERS_} array
according to the provided reference object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$pop.number(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{reference object of class 'number'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns invisible x.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-number.id"></a>}}
\if{latex}{\out{\hypertarget{method-number.id}{}}}
\subsection{Method \code{number.id()}}{
Given a reference object of class 'number', retrives and
returs the id of the associated \code{nummber}
(i.e. its position in the \code{NUMBERS_} array.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$number.id(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{reference object of class 'number'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the \code{number} id
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-number.exists"></a>}}
\if{latex}{\out{\hypertarget{method-number.exists}{}}}
\subsection{Method \code{number.exists()}}{
Checks that the \code{number} associated to a referece
object of class 'number' exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$number.exists(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{reference object of class 'number'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns TRUE if the \code{number} exists, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-number.gc"></a>}}
\if{latex}{\out{\hypertarget{method-number.gc}{}}}
\subsection{Method \code{number.gc()}}{
Calls the \code{number} garbage collector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$number.gc()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns invisible NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-apply.math_op"></a>}}
\if{latex}{\out{\hypertarget{method-apply.math_op}{}}}
\subsection{Method \code{apply.math_op()}}{
Applies a mathematical operator to its arguments.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$apply.math_op(op, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{op}}{operator name}

\item{\code{...}}{operator parameters}

\item{\code{name}}{name of the output \code{number}. If NULL is automatically generated}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a \code{number}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new.graph"></a>}}
\if{latex}{\out{\hypertarget{method-new.graph}{}}}
\subsection{Method \code{new.graph()}}{
Creates a new \code{graph} and return the corresponding
reference object of class 'graph'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$new.graph(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{graph} id}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a reference object of class 'graph'
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-graph.name.exists"></a>}}
\if{latex}{\out{\hypertarget{method-graph.name.exists}{}}}
\subsection{Method \code{graph.name.exists()}}{
Checks if a \code{graph} name exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$graph.name.exists(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\code{graph} name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns TRUE if the name exists, FALSE otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-graph.open"></a>}}
\if{latex}{\out{\hypertarget{method-graph.open}{}}}
\subsection{Method \code{graph.open()}}{
Opens a \code{graph}. 

if \code{g} is NULL a new graph is open  and appended to the
\code{graph} array. If a reference object
of class 'graph' is porvided the corresponding \code{graph}
is open.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$graph.open(g = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{g}}{reference object of class 'graph'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns an reference object of class 'graph'
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get.graph"></a>}}
\if{latex}{\out{\hypertarget{method-get.graph}{}}}
\subsection{Method \code{get.graph()}}{
Given a \code{graph} name (character identifier) creates
and returns a reference object of class 'graph'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$get.graph(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\code{graph} name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a reference object of class 'graph'.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pop.graph"></a>}}
\if{latex}{\out{\hypertarget{method-pop.graph}{}}}
\subsection{Method \code{pop.graph()}}{
Pops (removes) a \code{graph} from the \code{GRAPHS_} array.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$pop.graph(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{reference object of class 'graph'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns invisible x.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-graph.id"></a>}}
\if{latex}{\out{\hypertarget{method-graph.id}{}}}
\subsection{Method \code{graph.id()}}{
Given a reference object of class 'graph', retunrs
the id (i.e. position in the \code{GRAPHS_} array)
of the associated \code{graph}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$graph.id(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{reference object of class 'graph'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the \code{graph} id
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-graph.exists"></a>}}
\if{latex}{\out{\hypertarget{method-graph.exists}{}}}
\subsection{Method \code{graph.exists()}}{
Checks that the \code{graph} associated to a referece
object of class 'graph' exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$graph.exists(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{reference object of class 'graph'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns TRUE if the \code{graph} exists, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-graph.gc"></a>}}
\if{latex}{\out{\hypertarget{method-graph.gc}{}}}
\subsection{Method \code{graph.gc()}}{
Calls the \code{graph} garbage collector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$graph.gc()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns invisible NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new.opt"></a>}}
\if{latex}{\out{\hypertarget{method-new.opt}{}}}
\subsection{Method \code{new.opt()}}{
Creates a new \code{optimiser} and return the corresponding
reference object of class 'opt'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$new.opt(id, opt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{optimiser} id}

\item{\code{opt}}{R6 class indentifying the kind of optimiser}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a reference object of class 'opt'
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-opt.name.exists"></a>}}
\if{latex}{\out{\hypertarget{method-opt.name.exists}{}}}
\subsection{Method \code{opt.name.exists()}}{
Checks if a \code{optimiser} name exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$opt.name.exists(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\code{optimiser} name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns TRUE if the name exists, FALSE otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-append.opt"></a>}}
\if{latex}{\out{\hypertarget{method-append.opt}{}}}
\subsection{Method \code{append.opt()}}{
Append an \code{optimiser} with the given parameters to
the \code{OPTS_} array. A link to the \code{optimiser}
is created in \code{.opt} environment within the
session object. This method is called each time
a new \code{optimiser} is created.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$append.opt(append, opt, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{append}}{interface function for appending the optimiser to \code{GOPTS_}}

\item{\code{opt}}{character dincating the kind of optimiser}

\item{\code{...}}{optmiser parameters}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns an object of class 'opt' referring
to the appended \code{optmiser}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get.opt"></a>}}
\if{latex}{\out{\hypertarget{method-get.opt}{}}}
\subsection{Method \code{get.opt()}}{
Given a name (character identifier) for an \code{optimiser}
creates and returns a reference objects of class 'opt'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$get.opt(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\code{optimiser} name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a object of class 'opt'
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pop.opt"></a>}}
\if{latex}{\out{\hypertarget{method-pop.opt}{}}}
\subsection{Method \code{pop.opt()}}{
Pops (removes) an \code{optmiser} from the \code{OPTS_} array
according to the provided reference object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$pop.opt(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{reference object of class 'opt'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns invisible x.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-opt.id"></a>}}
\if{latex}{\out{\hypertarget{method-opt.id}{}}}
\subsection{Method \code{opt.id()}}{
Given a reference object of class 'opt', retrives and
returs the id of the associated \code{optmiser}
(i.e. its position in the \code{OPTS_} array.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$opt.id(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{reference object of class 'opt'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the \code{optmiser} id
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-opt.exists"></a>}}
\if{latex}{\out{\hypertarget{method-opt.exists}{}}}
\subsection{Method \code{opt.exists()}}{
Checks that the \code{optmiser} associated to a referece
object of class 'opt' exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$opt.exists(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{reference object of class 'opt'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns TRUE if the \code{optmiser} exists, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.modello.session$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
