% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataLoaders.R
\name{DataLoader.Seq}
\alias{DataLoader.Seq}
\title{R6 class representign a data loader for sequence datasets.}
\description{
R6 class representign a data loader for sequence datasets.

R6 class representign a data loader for sequence datasets.
}
\details{
It loads the data from a R array
}
\examples{

## ------------------------------------------------
## Method `DataLoader.Seq$length`
## ------------------------------------------------

ds = DataSet.Seq$new(matrix(rnorm(100), 20), 5, 1)
dl = DataLoader.Seq$new(ds, 5)
ds$length()
dl$length()

## ------------------------------------------------
## Method `DataLoader.Seq$has.next`
## ------------------------------------------------

ds = DataSet.Seq$new(matrix(rnorm(100), 20), 5, 1)
dl = DataLoader.Seq$new(ds, 5)
ds$has.next() # TRUE

## ------------------------------------------------
## Method `DataLoader.Seq$feed`
## ------------------------------------------------

modello.init()
ds = DataSet.Seq$new(matrix(rnorm(100), 20), 5, 1)
dl = DataLoader.Seq$new(ds, 5)
SEQ = dl$feed(NULL)
print(SEQ)
print(SEQ$X[[1]][[1]]$v)
dl$feed(SEQ)
print(SEQ$X[[1]][[1]]$v)
modello.close()
}
\author{
Filippo Monari
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DataLoader.Seq$new()}}
\item \href{#method-length}{\code{DataLoader.Seq$length()}}
\item \href{#method-has.next}{\code{DataLoader.Seq$has.next()}}
\item \href{#method-reset}{\code{DataLoader.Seq$reset()}}
\item \href{#method-feed}{\code{DataLoader.Seq$feed()}}
\item \href{#method-clone}{\code{DataLoader.Seq$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialisation method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataLoader.Seq$new(ds, bz)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ds}}{sequence datast}

\item{\code{bz}}{integer, batch size}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-length"></a>}}
\if{latex}{\out{\hypertarget{method-length}{}}}
\subsection{Method \code{length()}}{
Returns the length of teh data loader object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataLoader.Seq$length()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ds = DataSet.Seq$new(matrix(rnorm(100), 20), 5, 1)
dl = DataLoader.Seq$new(ds, 5)
ds$length()
dl$length()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-has.next"></a>}}
\if{latex}{\out{\hypertarget{method-has.next}{}}}
\subsection{Method \code{has.next()}}{
Returns TRUE if the data loader has still batches available
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataLoader.Seq$has.next()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ds = DataSet.Seq$new(matrix(rnorm(100), 20), 5, 1)
dl = DataLoader.Seq$new(ds, 5)
ds$has.next() # TRUE
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset"></a>}}
\if{latex}{\out{\hypertarget{method-reset}{}}}
\subsection{Method \code{reset()}}{
Resets the data loader to its initial state
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataLoader.Seq$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-feed"></a>}}
\if{latex}{\out{\hypertarget{method-feed}{}}}
\subsection{Method \code{feed()}}{
Feeds the data into a sequence of  batches of sequences or it creates a new one
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataLoader.Seq$feed(SEQ, mode = "head")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{SEQ}}{batch of sequences. If NULL it creates a new one}

\item{\code{mode}}{feeding mode}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{modello.init()
ds = DataSet.Seq$new(matrix(rnorm(100), 20), 5, 1)
dl = DataLoader.Seq$new(ds, 5)
SEQ = dl$feed(NULL)
print(SEQ)
print(SEQ$X[[1]][[1]]$v)
dl$feed(SEQ)
print(SEQ$X[[1]][[1]]$v)
modello.close()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataLoader.Seq$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
