% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{module.fc}
\alias{module.fc}
\title{R6 class representing a fully connected layer.}
\description{
R6 class representing a fully connected layer.

R6 class representing a fully connected layer.
}
\author{
Filippo Monari
}
\section{Super class}{
\code{\link[modello:module]{modello::module}} -> \code{module.fc}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{module.fc$new()}}
\item \href{#method-op}{\code{module.fc$op()}}
\item \href{#method-pars}{\code{module.fc$pars()}}
\item \href{#method-clone}{\code{module.fc$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="j">}\href{../../modello/html/module.html#method-j}{\code{modello::module$j()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="name">}\href{../../modello/html/module.html#method-name}{\code{modello::module$name()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="npars">}\href{../../modello/html/module.html#method-npars}{\code{modello::module$npars()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="obj">}\href{../../modello/html/module.html#method-obj}{\code{modello::module$obj()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="save">}\href{../../modello/html/module.html#method-save}{\code{modello::module$save()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="module" data-id="y">}\href{../../modello/html/module.html#method-y}{\code{modello::module$y()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
The initialisation method sets the weights (W), the bais (B) matrices,
the activation function (act), as well as the name of the module.
The calculation performed is the following
ans = act(W.op(X) + B)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.fc$new(tx, nin, nout, act)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tx}}{if TRUE it traspose the input matrix}

\item{\code{nin}}{number of column of the input matrix}

\item{\code{nout}}{number of hidden units}

\item{\code{act}}{activation function to adopt}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the total number of parameters
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-op"></a>}}
\if{latex}{\out{\hypertarget{method-op}{}}}
\subsection{Method \code{op()}}{
Performs: ans = act(W.op(X) + B)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.fc$op(X)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{input matrix, reference object of class 'number'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a reference object of class 'number'
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pars"></a>}}
\if{latex}{\out{\hypertarget{method-pars}{}}}
\subsection{Method \code{pars()}}{
Returns the parameters of the module as list with entries:
W = weight matrix, and B = bias matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.fc$pars()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns a flat list with the parametrs of the module
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module.fc$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
