% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers_math.R
\name{mae.modello_number}
\alias{mae.modello_number}
\alias{mae.default}
\alias{mae}
\title{Mean Absolute Error}
\usage{
\method{mae}{modello_number}(y, yh)

\method{mae}{default}(y, yh)

mae(y, yh)
}
\arguments{
\item{y}{target values}

\item{yh}{predictions}
}
\value{
Returns the mse
}
\description{
Calculates the mean absolute error between target values and predictions
\deqn{mae = \sum_i^N{|y_i - \hat y_i|} / N}
}
\examples{
modello.init(10, 10, 10, 10)
## For modello_numbers
y = number(rnorm(10), dx=FALSE)
yh = number(rnorm(10), dx=FALSE)
h = mae(y, yh)
print(h)
print(h$v)
modello.close()
## For numerics
y = rnorm(10)
yh = rnorm(10)
h = mae(y, yh)
print(h)
}
\author{
Filippo Monari
}
