% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataLoaders.R
\name{DataSet.Seq}
\alias{DataSet.Seq}
\title{R6 class representign a dataset of sequences to feed RNN}
\description{
R6 class representign a dataset of sequences to feed RNN

R6 class representign a dataset of sequences to feed RNN
}
\details{
It load the data from a R array
}
\examples{

## ------------------------------------------------
## Method `DataSet.Seq$length`
## ------------------------------------------------

ds = DataSet.Seq$new(matrix(rnorm(100), 20), 5, 1)
ds$length() # 20

## ------------------------------------------------
## Method `DataSet.Seq$feed`
## ------------------------------------------------

modello.init(100, 100, 100, 100)
ds = DataSet.Seq$new(matrix(rnorm(100), 20), 5, 1)
SEQ = ds$feed(NULL)
print(names(SEQ))
print(SEQ$x[[1]]$v)
print(SEQ$y$v)
ds$feed(SEQ)
print(SEQ$x[[1]]$v)
print(SEQ$y$v)
modello.close()

## ------------------------------------------------
## Method `DataSet.Seq$rewind`
## ------------------------------------------------

ds = DataSet.Seq$new(matrix(rnorm(100), 20), 5, 1)
ds$..get.data..("head")
ds$..get.data..("head")
ds$rewind(2)
ds$..get.data..("head")
ds$..get.data..("head")
}
\author{
Filippo Monari
}
\section{Super class}{
\code{\link[modello:DataSet.Array]{modello::DataSet.Array}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DataSet.Seq$new()}}
\item \href{#method-length}{\code{DataSet.Seq$length()}}
\item \href{#method-feed}{\code{DataSet.Seq$feed()}}
\item \href{#method-rewind}{\code{DataSet.Seq$rewind()}}
\item \href{#method-..pop.index..}{\code{DataSet.Seq$..pop.index..()}}
\item \href{#method-..feed..}{\code{DataSet.Seq$..feed..()}}
\item \href{#method-..get.data..}{\code{DataSet.Seq$..get.data..()}}
\item \href{#method-clone}{\code{DataSet.Seq$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="DataSet.Array" data-id="has.next">}\href{../../modello/html/DataSet.Array.html#method-has.next}{\code{modello::DataSet.Array$has.next()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="modello" data-topic="DataSet.Array" data-id="reset">}\href{../../modello/html/DataSet.Array.html#method-reset}{\code{modello::DataSet.Array$reset()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialisation method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.Seq$new(X, ls, yi, indexes = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{matrix/array}

\item{\code{ls}}{integer, sequence length}

\item{\code{yi}}{integer vector, subset of indices to return a targets}

\item{\code{indexes}}{integer vector, a subset of indexes
indicating the starting point fir the sequences}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-length"></a>}}
\if{latex}{\out{\hypertarget{method-length}{}}}
\subsection{Method \code{length()}}{
Returns the length of the dataset
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.Seq$length()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ds = DataSet.Seq$new(matrix(rnorm(100), 20), 5, 1)
ds$length() # 20
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-feed"></a>}}
\if{latex}{\out{\hypertarget{method-feed}{}}}
\subsection{Method \code{feed()}}{
Feeds the data into an existing seqience or creating a new one
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.Seq$feed(x, mode = "head")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{existing sequence, if NULL it creates a new one}

\item{\code{mode}}{chectacter indicating the way to build the sequences}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{modello.init(100, 100, 100, 100)
ds = DataSet.Seq$new(matrix(rnorm(100), 20), 5, 1)
SEQ = ds$feed(NULL)
print(names(SEQ))
print(SEQ$x[[1]]$v)
print(SEQ$y$v)
ds$feed(SEQ)
print(SEQ$x[[1]]$v)
print(SEQ$y$v)
modello.close()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rewind"></a>}}
\if{latex}{\out{\hypertarget{method-rewind}{}}}
\subsection{Method \code{rewind()}}{
Sets the data loader back of n previous states.
Only available for "head" and "tail" modes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.Seq$rewind(n, mode = "head")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of step to rewind}

\item{\code{mode}}{rewind mode. Possibly the same as the feed mode.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ds = DataSet.Seq$new(matrix(rnorm(100), 20), 5, 1)
ds$..get.data..("head")
ds$..get.data..("head")
ds$rewind(2)
ds$..get.data..("head")
ds$..get.data..("head")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-..pop.index.."></a>}}
\if{latex}{\out{\hypertarget{method-..pop.index..}{}}}
\subsection{Method \code{..pop.index..()}}{
Auxiliary method not to be called directly.
It pops an index from the dataset according to the given method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.Seq$..pop.index..(mode = "head")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{popping mode}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-..feed.."></a>}}
\if{latex}{\out{\hypertarget{method-..feed..}{}}}
\subsection{Method \code{..feed..()}}{
Auxiliary method. Not to be called directly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.Seq$..feed..(x, mode)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{existing sequence, if NULL it creates a new one}

\item{\code{mode}}{chectacter indicating the way to build the sequences}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-..get.data.."></a>}}
\if{latex}{\out{\hypertarget{method-..get.data..}{}}}
\subsection{Method \code{..get.data..()}}{
Auxiliary method. Not to be called directly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.Seq$..get.data..(mode)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{chectacter indicating the way to build the sequences}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSet.Seq$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
