% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive_statistics.R
\name{get_top_corrs}
\alias{get_top_corrs}
\title{Get the correlation of variables in a dataset with a given response,
sorted highest to lowest}
\usage{
get_top_corrs(dat, response_var, parallel = FALSE)
}
\arguments{
\item{dat}{a tbl}

\item{response_var}{character string containing the name of a variable in
\code{dat} that you would like the correlations to be computed with,
or an integer specifying the position of this variable}

\item{parallel}{logical. If \code{TRUE}, parallel
\code{\link[foreach]{foreach}} is used for computing correlations
(if FALSE, single threaded foreach is used; still highly efficient).
Default is \code{FALSE}.}
}
\value{
a tbl with two columns: \code{var_name} gives the name of each
        variable and \code{correlation} gives its correlation with
        \code{response_var}.
}
\description{
This function computes the correlation of each input variable in a dataframe
with a given response variable and returns a dataframe listing the variables
sorted in order of most to least correlated. NAs are removed from correlation
computations, and only numeric variables are considered.
}
\details{
Use this technique for filtering out variables in the initial stages of data
analysis, to get more familiar with how the individual input variables relate
to the response variable of interest. Not recommended as a formal variable
selection technique, since it will ignore interactions between inputs.
}
\examples{
x <- iris
get_top_corrs(x,"Petal.Length")

}
\seealso{
Other descriptive: \code{\link{proc_freq}}
}

