% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binom_revweib.R
\name{binom_revweib}
\alias{binom_revweib}
\title{Reverse Weibull model for the psychometric function}
\usage{
binom_revweib( r, m, x, p = 1, initK = 2, guessing = 0, lapsing = 0 )
}
\arguments{
\item{r}{number of successes at points x}

\item{m}{number of trials at points x}

\item{x}{stimulus levels}

\item{p}{(optional) degree of the polynomial; default is 1}

\item{initK}{(optional) initial value for K (power parameter in reverse Weibull model); default is 2}

\item{guessing}{(optional) guessing rate; default is 0}

\item{lapsing}{(optional) lapsing rate; default is 0}
}
\value{
\verb{b    } vector of estimated coefficients for the linear part

\verb{K    } estiamte of the power parameter in the reverse Weibull model

\verb{fit  } glm object to be used in evaluation of fitted values
}
\description{
This function finds the maximum likelihood estimates of the parameters
of the reverse Weibull model for the psychometric function.
}
\examples{
data("Miranda_Henson")
x = Miranda_Henson$x
r = Miranda_Henson$r
m = Miranda_Henson$m
numxfit <- 199; # Number of new points to be generated minus 1
xfit <- (max(x)-min(x)) * (0:numxfit) / numxfit + min(x)
val <- binom_revweib( r, m, x )
# Plot the fitted curve
plot( x, r / m, xlim = c( 0.1, 1.302 ), ylim = c( 0.0165, 0.965 ), type = "p", pch="*" )
pfit <- predict( val$fit, data.frame( x = xfit ), type = "response" )
lines(xfit, pfit, col = "green" )

}
