% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animals.R
\name{data_animals}
\alias{data_animals}
\title{animals data set}
\source{
\url{https://github.com/emilhvitfeldt/animals}
}
\usage{
data_animals(...)
}
\arguments{
\item{...}{Arguments passed to \code{\link[pins:pin_read]{pins::pin_read()}}.}
}
\value{
tibble
}
\description{
Data set with characteristics of many animals, including the field \code{text}
which is a long-form description of the animal.
}
\details{
This data set contains quite a bit of missing data and malformed fiels.
}
\section{tibble print}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{data_animals()
#> # A tibble: 610 x 48
#>    text    colour lifespan weight kingdom class phylum diet  conservation_status
#>    <chr>   <chr>  <chr>    <chr>  <chr>   <chr> <chr>  <chr> <chr>              
#>  1 "Aardv~ Brown~ 23 years 60kg ~ Animal~ Mamm~ Chord~ Omni~ Least Concern      
#>  2 "Abyss~ Fawn,~ <NA>     <NA>   <NA>    <NA>  <NA>   <NA>  <NA>               
#>  3 "Adeli~ Black~ 10 - 20~ 3kg -~ Animal~ Aves  Chord~ Carn~ Least Concern      
#>  4 "Affen~ Black~ <NA>     <NA>   <NA>    <NA>  <NA>   <NA>  <NA>               
#>  5 "Afgha~ Black~ <NA>     <NA>   <NA>    <NA>  <NA>   <NA>  <NA>               
#>  6 "Afric~ Grey,~ 60 - 70~ 3,600~ Animal~ Mamm~ Chord~ Herb~ Threatened         
#>  7 "Afric~ Black~ 15 - 20~ 1.4kg~ Animal~ Mamm~ Chord~ Omni~ Least Concern      
#>  8 "Afric~ Brown~ 8 - 15 ~ 25g -~ Animal~ Amph~ Chord~ Carn~ Least Concern      
#>  9 "Afric~ Grey,~ 60 - 70~ 900kg~ Animal~ Mamm~ Chord~ Herb~ Endangered         
#> 10 "Afric~ Black~ 15 - 20~ 1.4kg~ Animal~ Mamm~ Chord~ Omni~ Least Concern      
#> # i 600 more rows
#> # i 39 more variables: order <chr>, scientific_name <chr>, skin_type <chr>,
#> #   habitat <chr>, predators <chr>, family <chr>, lifestyle <chr>,
#> #   average_litter_size <chr>, genus <chr>, top_speed <chr>,
#> #   favourite_food <chr>, main_prey <chr>, type <chr>, common_name <chr>,
#> #   group <chr>, size <chr>, distinctive_features <chr>, size_l <chr>,
#> #   origin <chr>, special_features <chr>, location <chr>, ...
}\if{html}{\out{</div>}}
}

\section{glimpse()}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{tibble::glimpse(data_animals())
#> Rows: 610
#> Columns: 48
#> $ text                      <chr> "Aardvark Classification and Evolution\\nAard~
#> $ colour                    <chr> "Brown, grey, yellow", "Fawn, Red, Blue, Gre~
#> $ lifespan                  <chr> "23 years", NA, "10 - 20 years", NA, NA, "60~
#> $ weight                    <chr> "60kg - 80kg (130lbs - 180lbs)", NA, "3kg - ~
#> $ kingdom                   <chr> "Animalia", NA, "Animalia", NA, NA, "Animali~
#> $ class                     <chr> "Mammalia", NA, "Aves", NA, NA, "Mammalia", ~
#> $ phylum                    <chr> "Chordata", NA, "Chordata", NA, NA, "Chordat~
#> $ diet                      <chr> "Omnivore", NA, "Carnivore", NA, NA, "Herbiv~
#> $ conservation_status       <chr> "Least Concern", NA, "Least Concern", NA, NA~
#> $ order                     <chr> "Tubulidentata", NA, "Sphenisciformes", NA, ~
#> $ scientific_name           <chr> "Orycteropus afer", NA, "Pygoscelis adeliae"~
#> $ skin_type                 <chr> "Hair", NA, "Feathers", NA, NA, "Leather", "~
#> $ habitat                   <chr> "Sandy and clay soil", NA, "Antarctic land a~
#> $ predators                 <chr> "Lions, Leopards, Hyenas", NA, "Leopard Seal~
#> $ family                    <chr> "Orycteropodidae", NA, "Spheniscidae", NA, N~
#> $ lifestyle                 <chr> "Nocturnal", NA, "Diurnal", NA, NA, "Diurnal~
#> $ average_litter_size       <chr> "1", "6", NA, "3", "7", "1", "3", NA, "1", "~
#> $ genus                     <chr> "Orycteropus", NA, "Pygoscelis", NA, NA, "Lo~
#> $ top_speed                 <chr> "40kph (25mph)", NA, "72kph (45mph)", NA, NA~
#> $ favourite_food            <chr> NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, ~
#> $ main_prey                 <chr> NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, ~
#> $ type                      <chr> NA, "Shorthair", NA, "Terrier", "Hound", NA,~
#> $ common_name               <chr> "Aardvark", "Abyssinian", "Adelie Penguin", ~
#> $ group                     <chr> "Mammal", "Cat", "Bird", "Dog", "Dog", "Mamm~
#> $ size                      <chr> NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, ~
#> $ distinctive_features      <chr> NA, "Silky fur and almond shaped eyes", NA, ~
#> $ size_l                    <chr> "1.05m - 2.20m (3.4ft - 7.3ft)", NA, NA, NA,~
#> $ origin                    <chr> NA, "Egypt", NA, "Germany", "Afghanistan", N~
#> $ special_features          <chr> NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, ~
#> $ location                  <chr> "Sub-Saharan Africa", NA, "Coastal Antarctic~
#> $ number_of_species         <chr> "18", NA, "1", NA, NA, "1", "1", "1", "1", "~
#> $ average_clutch_size       <chr> NA, NA, "2", NA, NA, NA, NA, NA, NA, NA, "2"~
#> $ size_h                    <chr> NA, NA, "40cm - 75cm (16in - 30in)", NA, NA,~
#> $ group_behaviour           <chr> "Solitary", NA, "Colony", NA, NA, "Herd", "S~
#> $ fun_fact                  <chr> "Can move up to 2ft of soil in just 15 secon~
#> $ age_of_sexual_maturity    <chr> "2 years", NA, "2 - 3 years", NA, NA, "11 - ~
#> $ name_of_young             <chr> "Cub", NA, "Chicks", NA, NA, "Calf", "Pup", ~
#> $ prey                      <chr> "Termites, Ants", NA, "Krill, Fish, Squid", ~
#> $ estimated_population_size <chr> "Unknown", NA, "5 million", NA, NA, "300,000~
#> $ biggest_threat            <chr> "Habitat loss", NA, "Rapid ice melt", NA, NA~
#> $ average_lifespan          <chr> NA, "15 years", NA, "12 years", "14 years", ~
#> $ most_distinctive_feature  <chr> "Long, sticky tongue and rabbit-like ears", ~
#> $ other_name_s              <chr> "Antbear, Earth Pig", NA, NA, NA, NA, "Afric~
#> $ gestation_period          <chr> "7 months", NA, NA, NA, NA, "20 - 24 months"~
#> $ age_of_weaning            <chr> "3 months", NA, NA, NA, NA, "6 - 18 months",~
#> $ average_weight            <chr> NA, "4.5kg (10lbs)", NA, "3.6kg (8lbs)", "27~
#> $ temperament               <chr> NA, "Intelligent and curious", NA, "Alert an~
#> $ wingspan                  <chr> NA, NA, "35cm - 70cm (14in - 27.5in)", NA, N~
}\if{html}{\out{</div>}}
}

\examples{
\donttest{
data_animals()
}
}
