% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diversity_Area_Relationships.R
\name{divar}
\alias{divar}
\title{Diversity-area relationships}
\usage{
divar(
  comm,
  prop_area = seq(0.1, 1, by = 0.1),
  n_samples = 100,
  exclude_zeros = T
)
}
\arguments{
\item{comm}{\code{\link{community}} object}

\item{prop_area}{Subplot sizes as proportion of the total area (numeric)}

\item{n_samples}{Number of randomly located subplots per subplot size (single integer)}

\item{exclude_zeros}{Should subplots without individuals be excluded? (logical)}
}
\value{
Dataframe with the proportional area of the subplots and mean and
standard deviation of the following diversity indices:
\enumerate{
   \item Number of species
   \item Number of endemics
   \item Shannon index
   \item Effective number of species (ENS) based on Shannon index
   \item Simpson index
   \item Effective number of species (ENS) based on Simpson index
}

See the documentation of  \code{\link{div_rect}} for detailed information on the
definition of the diversity indices.
}
\description{
Estimate diversity indices in subplots of different sizes. This includes the
well-known species-area and endemics-area relationships.
}
\examples{
sim1 <- sim_thomas_community(100, 1000)
divar1 <- divar(sim1, prop_area = seq(0.01, 1.0, length = 20))
plot(divar1)

}
\seealso{
\code{\link{div_rand_rect}}, \code{\link{div_rect}}
}
