% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qnormFast}
\alias{qnormFast}
\title{Quantile function of a normal distribution}
\usage{
qnormFast(
  p,
  mean = 0L,
  sd = 1L,
  method = "Voutier",
  is_validation = TRUE,
  n_cores = 1L
)
}
\arguments{
\item{p}{numeric vector of values between 0 and 1 representing levels of
the quantiles.}

\item{mean}{numeric value representing the expectation of a
normal distribution.}

\item{sd}{positive numeric value representing standard deviation of a
normal distribution.}

\item{method}{character representing the method to be used for
quantile calculation. Available options are "Voutier" (default) and "Shore".}

\item{is_validation}{logical value indicating whether input 
arguments should be validated.  Set it to \code{FALSE} to get
performance boost (default value is \code{TRUE}).}

\item{n_cores}{positive integer representing the number of CPU cores
used for parallel computing. Currently it is not recommended to set
\code{n_cores > 1} if vectorized arguments include less then 100000 elements.}
}
\value{
The function returns a vector of \code{p}-level quantiles of a
normal distribution with mean equal to \code{mean} and standard 
deviation equal to \code{sd}.
}
\description{
Calculate quantile of a normal distribution using
one of the available methods.
}
\details{
If \code{method = "Voutier"} then the method of P. Voutier (2010)
is used which maximum absolute error is about \eqn{0.000025}.
If \code{method = "Shore"} then the approach proposed
by H. Shore (1982) is applied which maximum absolute error is about
\eqn{0.026} for quantiles of level between \eqn{0.0001} 
and \eqn{0.9999}.
}
\examples{
qnormFast(c(0.1, 0.9), mean = 1, sd = 2)
}
\references{
H. Shore (1982) <doi:10.2307/2347972>

P. Voutier (2010) <doi:10.48550/arXiv.1002.0567>
}
