% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_full_biog.R
\name{mnis_full_biog}
\alias{mnis_full_biog}
\title{mnis_full_biog}
\usage{
mnis_full_biog(ID = NULL, ref_dods = FALSE, tidy = TRUE,
  tidy_style = "snake_case")
}
\arguments{
\item{ID}{The ID number of the member, using the default MNIS scheme. If \code{ref_dods} is TRUE, accepts the Dods monitoring scheme instead. If left empty, returns the same data as \code{\link{mnis_all_members}}.}

\item{ref_dods}{Request based on the Dods monitoring member ID scheme. Defaults to FALSE. If FALSE, requests using the default MNIS identification scheme.}

\item{tidy}{Fix the variable names in the tibble to remove non-alphanumeric characters and superfluous text, and convert variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy=TRUE. Accepts one of "snake_case", "camelCase" and "period.case". Defaults to "snake_case".}
}
\description{
Requests all available biographical information for a given member, and returns it in the form of a tibble.
}
\examples{
\dontrun{
x <- mnis_full_biog(172)

}
}
\seealso{
\code{\link{mnis_basic_details}} \code{\link{mnis_additional}}
}
\keyword{mnis}
