% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_table_cells.R
\name{replext_t2_c1}
\alias{replext_t2_c1}
\title{Generate Replext Tables for Linear Regression Analysis}
\usage{
replext_t2_c1(
  S = 20000,
  p = 3,
  f2s = c(0.02, 0.05, 0.08, 0.1, 0.15, 0.2, 0.25, 0.35),
  n_start = 6,
  constrs = c(0, 1, 2, 3),
  rho = 0,
  beta = 0.1,
  alpha = 0.05,
  pow = 0.8,
  standardize = TRUE,
  nmax = 1000
)
}
\arguments{
\item{S}{The number of datasets to generate for each simulation, default is 20000.}

\item{p}{The number of predictors in the regression model.}

\item{f2s}{A vector of effect sizes to be used in the simulations.}

\item{n_start}{The starting sample size for the simulations.}

\item{constrs}{A vector of constraint types (number of inequality constraints)
to be applied in the simulations.}

\item{rho}{The correlation coefficient between predictors, default is 0.0.}

\item{beta}{The regression coefficient for predictors, default is 0.1.}

\item{alpha}{The significance level used in hypothesis testing, default is 0.05.}

\item{pow}{The desired power for the statistical test, default is 0.80.}

\item{standardize}{A logical flag to indicate whether to standardize the
predictors in the datasets, default is TRUE.}

\item{nmax}{The maximum sample size to consider in the simulations.}
}
\value{
A data frame containing Type I error rates and the minimum sample sizes
required for each combination of effect size and constraint type.
}
\description{
This function generates replext tables for linear regression, similar to those
in Table 2 Cell 1 of the referenced paper. It computes minimum sample sizes for
various power and effect size combinations, and calculates Type I error rates.
}
\details{
The function uses a nested approach to first determine minimum sample
sizes for different combinations of effect size and constraints, and then
calculates Type I error rates. It leverages the \code{lr_pow} function for power
calculation and uses \code{generate_datasets_reg} for dataset generation.
}
\examples{
replext_t2_c1(S = 2, f2s = c(0.35), constrs = c(2))

}
\references{
Vanbrabant, Leonard; Van De Schoot, Rens; Rosseel, Yves (2015). Constrained
statistical inference: sample-size tables for ANOVA and regression. Frontiers
in Psychology, 5. DOI:10.3389/fpsyg.2014.01565.
URL: https://www.frontiersin.org/articles/10.3389/fpsyg.2014.01565
}
