% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_game_mgmt.R
\name{process_hand}
\alias{process_hand}
\title{Process Hand and Calculate Mispecification Distance in CloseCATs Game}
\usage{
process_hand(
  x,
  process_col,
  beta_int = 0,
  beta_x1 = 0.25,
  beta_x2 = 1.5,
  mean_x1 = 0,
  sd_x1 = 1,
  mean_x2 = 0,
  sd_x2 = 4,
  N = 20,
  reps = 1,
  alpha = 0.05,
  n_time = 20,
  mean_i = 0,
  var_i = 1,
  mean_s = 0,
  mean_r = 0,
  var_r = 1,
  cor_pred = NULL,
  truncate = FALSE,
  var_s_factor = 1,
  cov_is_factor = 14.75
)
}
\arguments{
\item{x}{A matrix representing the current hand in the game grid.}

\item{process_col}{The column number (1 for computer, 2 for player) to process.}

\item{beta_int}{Intercept for the mixed effects model.}

\item{beta_x1}{Coefficient for the first predictor in the mixed effects model.}

\item{beta_x2}{Coefficient for the second predictor in the mixed effects model.}

\item{mean_x1}{Mean of the first predictor.}

\item{sd_x1}{Standard deviation of the first predictor.}

\item{mean_x2}{Mean of the second predictor.}

\item{sd_x2}{Standard deviation of the second predictor.}

\item{N}{Number of observations.}

\item{reps}{Number of replications for the power analysis.}

\item{alpha}{Significance level for the power analysis.}

\item{n_time}{Number of time points.}

\item{mean_i}{Mean of the random intercept.}

\item{var_i}{Variance of the random intercept.}

\item{mean_s}{Mean of the random slope.}

\item{mean_r}{Mean of the residual.}

\item{var_r}{Variance of the residual.}

\item{cor_pred}{Correlation predictor, NULL if not specified.}

\item{truncate}{Boolean to determine if truncation is applied in the model.}

\item{var_s_factor}{Factor to adjust the variance of the random slope.}

\item{cov_is_factor}{Factor to adjust the covariance between the random intercept
and slope.}
}
\value{
A list containing two elements: 'mispec_dist', the mispecification
distance, and 'results', a summary of model results and their statistical
parameters.
}
\description{
This function processes hands in the CloseCATs game and calculates the
mispecification distance. It performs statistical computations based on the
dealt cards and specified parameters, evaluating the performance of mixed effects
models and cluster adjusted t-statistics models in the context of the game.
The function considers various statistical parameters and model specifications
to compute the results.
}
\keyword{internal}
