\name{summary.mma}
\alias{summary.mma}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Summary of an mma project
}
\description{
Compute the estimations, standard deviations and confidence intervals of the mediation effects.
}
\usage{
\method{summary}{mma}(object,..., alpha=0.05, plot=TRUE) 
}
%- maybe also 'usage' for other objects documented here.
\arguments{
 \item{object}{
a mma object created initially call to mma, boot.met.binx, or boot.met.contx.
}
  \item{\dots}{
other arguments passed to the print function.
}
  \item{alpha}{
the alpha level for confidence interval.}
  \item{plot}{
default is TRUE, if ture, draw a barplot of the relative mediation effects.}
}
\details{
summary.mma gives a list of the estimations and summary statistics based on the bootstrap results. If plot=T, draw a barplot of the relative effects of the direct effect of the predictor and indirect effects of the mediators. Relative effects is defined as the (in)direct effect divided by the total effect. The plot is arranged in order from the largest to the smallest relative effect.
}
\value{
Return a list.  In each of the following item, est is the estimation of the corresponding mediation effects based on the whole data, mean is the average estimated effects from the bootstrap samples, sd is the standard deviation of the estimates from the bootstrap sample. upbd and lwbd are the upper and lower bound of the confidence interval of the estimation using parametric method from the bootstrap sample, upbd_q and lwbd_q are the corresponding quantiles of the estimation from the bootstrap sample.
  \item{ie }{a matrix of statistics inference on the indirect effects from the mma object.}
  \item{te }{statistics inference on the total effects from the mma object.}
  \item{de }{statistics inference on the direct effects from the mma object.}
If plot=T, draw a barplot of the relative mediation effects.
}
\references{
Yu, Q., Fan, Y., and Wu, X. (2014). "General Multiple Mediation Analysis With an Application to Explore Racial Disparity in Breast Cancer Survival," Journal of Biometrics & Biostatistics,5(2): 189. 
}
\author{
Qingzhao Yu \email{qyu@lsuhsc.edu}
}

\seealso{
\code{"\link[=mma]{mma}"},\code{"\link[=boot.med.binx]{boot.med.binx}"} , \code{"\link[=boot.med.contx]{boot.met.contx}"}
}
\examples{
data("weight_behavior")
 x=weight_behavior[,2:14]
 y=weight_behavior[,15]
 temp.b.b.glm<-mma(x,y,pred=2,contmed=c(8:10,12:13),binmed=c(7,11),
   binref=c(1,1),catmed=6,catref=1,predref="M",alpha=0.4,alpha2=0.4, 
   jointm=NULL,margin=1, n=2,seed=sample(1:1000,1),mart=FALSE,nu=0.001,
   D=3,distn="bernoulli",family1=binomial(link = "logit"),n2=2)
 summary(temp.b.b.glm)
}

%\keyword{ Summary }
