% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apiManager.R
\name{initMlxR}
\alias{initMlxR}
\title{Initialize mlxR library}
\usage{
initMlxR(path = NULL, ...)
}
\arguments{
\item{path}{(\emph{character}) [optional] Path to installation directory of the Lixoft suite.
If mlxR library is not already loaded and no path is given, the directory written in the lixoft.ini file is used for initialization.}

\item{...}{[optional] Extra arguments passed to lixoftConnectors package when mlxR is used with a version of Lixoft(/@) software suite higher or equal to 2019R1.
\itemize{
\item \code{force} (\emph{bool}) [optional] Should mlxR initialization overpass lixoftConnectors software switch security or not. Equals FALSE by default.
}}
}
\value{
A list:
\itemize{
  \item \code{software}: the software that is used (should be monolix with Rsmlx)
  \item \code{path}: the path to MonolixSuite
  \item \code{version}: the version of MonolixSuite that is used
  \item \code{status}: boolean equaling TRUE if the initialization has been successful.
}
}
\description{
Initialize mlxR library
}
\examples{
\dontrun{
initMlxR(path = "/path/to/lixoftRuntime/")
}
}
