% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sim_T}
\alias{sim_T}
\title{bootstrap distribution}
\usage{
sim_T(X, t, sigma, m, B, type = 0L)
}
\arguments{
\item{X, }{matrix of covariates}

\item{t, }{vector of time points}

\item{sigma, }{a cube of long-run covariance function.}

\item{m, }{int value of window size}

\item{B, }{int, number of iteration}

\item{type, }{type of tests, residual-based or coefficient-based}
}
\value{
a vector of bootstrap statistics
}
\description{
bootstrap distribution of the gradient based structural stability test
}
\examples{
param = list(B = 50, bw_set = c(0.15, 0.25), gcv =1, neighbour = 1, lb = 10, ub = 20, type = 0)
n = 300
data = bregress2(n, 2, 1) # time series regression model with 2 changes points
sigma = Heter_LRV(data$y, data$x, 3, 0.3, lrv_method = 1)
bootstrap = sim_T(data$x, (1:n)/n, sigma, 3, 20) ### 20 iterations
}
