% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exampleRunMultiObj.R
\name{exampleRunMultiObj}
\alias{exampleRunMultiObj}
\title{Perform an MBO run on a multi-objective test function and and visualize what happens.}
\usage{
exampleRunMultiObj(fun, design = NULL, learner, control,
  points.per.dim = 50, show.info = NULL, nsga2.args = list(), ...)
}
\arguments{
\item{fun}{[\code{smoof_function}]\cr
Fitness function to optimize.
For one dimensional target functions you can obtain a \code{smoof_function} by using \code{\link[smoof]{makeSingleObjectiveFunction}}.
For multi dimensional functions use \code{\link[smoof]{makeMultiObjectiveFunction}}.
It is possible to return even more information which will be stored
in the optimization path. To achieve this, simply append the attribute \dQuote{extras}
to the return value of the target function. This has to be a named list of scalar values.
Each of these values will be stored additionally in the optimization path.}

\item{design}{[\code{data.frame}]\cr
Initial design as data frame.
If the y-values are not already present in design, mbo will evaluate the points.
If the parameters have corresponding trafo functions, the design must not be transformed before it is passed!
Functions to generate designs are available in \code{ParamHelpers}: \code{\link[ParamHelpers]{generateDesign}}, \code{\link[ParamHelpers]{generateGridDesign}}, \code{\link[ParamHelpers]{generateRandomDesign}}.
Default is \code{NULL}, which means \code{\link[ParamHelpers]{generateDesign}} is called and a design of size 4 times number of all parameters is created
The points are drawn via \code{\link[lhs]{maximinLHS}} to maximize the minimal distance between design points.}

\item{learner}{[\code{\link[mlr]{Learner}}]\cr
Regression learner from mlr, which is used as a surrogate to model our fitness function.
If \code{NULL} (default), the default learner is determined as described here: \link{mbo_default_learner}.}

\item{control}{[\code{\link{MBOControl}}]\cr
Control object for mbo.}

\item{points.per.dim}{[\code{integer}]\cr
Number of (regular spaced) locations at which to
sample the \code{fun} function per dimension.
Default is 50.}

\item{show.info}{[\code{logical(1)}]\cr
Verbose output on console?
Default is \code{TRUE}.}

\item{nsga2.args}{[\code{list}]\cr
Further arguments passed to the nsga2 call.
Default is \code{list()}.}

\item{...}{[any]\cr
Further arguments passed to the learner.}
}
\value{
[\code{MBOExampleRunMultiObj}]
}
\description{
Only available for 2D -> 2D examples,
useful for figuring out how stuff works and for teaching purposes.
Currently only parameter spaces with numerical parameters are supported.
For visualization, run \code{plotExampleRun} on the resulting object.
What is displayed is documented here: \code{\link{plotExampleRun}}.
}
\note{
If the passed objective function has no associated reference point max(y_i) + 1
of the nsga2 front is used.
}
