% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoTuner.R
\name{set_validate.AutoTuner}
\alias{set_validate.AutoTuner}
\title{Configure Validation for AutoTuner}
\usage{
\method{set_validate}{AutoTuner}(learner, validate, final_validate, ...)
}
\arguments{
\item{learner}{(\code{\link{AutoTuner}})\cr
The autotuner for which to enable validation.}

\item{validate}{(\code{numeric(1)}, \code{"predefined"}, \code{"test"}, or \code{NULL})\cr
How to configure the validation during the hyperparameter tuning.}

\item{final_validate}{(\code{numeric(1)}, \code{"predefined"}, \code{"test"} or \code{NULL})\cr
How to configure the validation during the final model fit.
The default behavior is to not change the value.
Rarely needed.}

\item{...}{(any)\cr
Passed when calling \code{set_validate()} on the wrapped leaerner.}
}
\description{
Configure validation for the final model fit (\code{final_validate}), as well as
during the tuning (\code{validate}).
}
\examples{
at = auto_tuner(
  tuner = tnr("random_search"),
  learner = lrn("classif.debug", early_stopping = TRUE,
    iter = to_tune(upper = 1000L, internal = TRUE), validate = 0.2),
  resampling = rsmp("holdout")
)
# use the test set as validation data during tuning
set_validate(at, validate = "test")
at$learner$validate
}
