% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpTorchIngress.R
\name{TorchIngressToken}
\alias{TorchIngressToken}
\title{Torch Ingress Token}
\usage{
TorchIngressToken(features, batchgetter, shape = NULL)
}
\arguments{
\item{features}{(\code{character} or \code{mlr3pipelines::Selector})\cr
Features on which the batchgetter will operate or a selector (such as \code{\link[mlr3pipelines:Selector]{mlr3pipelines::selector_type}}).}

\item{batchgetter}{(\code{function})\cr
Function with two arguments: \code{data} and \code{device}. This function is given
the output of \code{Task$data(rows = batch_indices, cols = features)}
and it should produce a tensor of shape \code{shape_out}.}

\item{shape}{(\code{integer})\cr
Shape that \code{batchgetter} will produce. Batch dimension must be included as \code{NA} (but other dimensions can also be \code{NA}, i.e., unknown).}
}
\value{
\code{TorchIngressToken} object.
}
\description{
This function creates an S3 class of class \code{"TorchIngressToken"}, which is an internal data structure.
It contains the (meta-)information of how a batch is generated from a \code{\link[mlr3:Task]{Task}} and fed into an entry point
of the neural network. It is stored as the \code{ingress} field in a \code{\link{ModelDescriptor}}.
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Define a task for which we want to define an ingress token
task = tsk("iris")

# We create an ingress token for two feature Sepal.Length and Petal.Length:
# We have to specify the features, the batchgetter and the shape
features = c("Sepal.Length", "Petal.Length")
# As a batchgetter we use batchgetter_num

batch_dt = task$data(rows = 1:10, cols =features)
batch_dt
batch_tensor = batchgetter_num(batch_dt, "cpu")
batch_tensor

# The shape is unknown in the first dimension (batch dimension)

ingress_token = TorchIngressToken(
  features = features,
  batchgetter = batchgetter_num,
  shape = c(NA, 2)
)
ingress_token
\dontshow{\}) # examplesIf}
}
\seealso{
Other Graph Network: 
\code{\link{ModelDescriptor}()},
\code{\link{mlr_learners_torch_model}},
\code{\link{mlr_pipeops_module}},
\code{\link{mlr_pipeops_torch}},
\code{\link{mlr_pipeops_torch_ingress}},
\code{\link{mlr_pipeops_torch_ingress_categ}},
\code{\link{mlr_pipeops_torch_ingress_ltnsr}},
\code{\link{mlr_pipeops_torch_ingress_num}},
\code{\link{model_descriptor_to_learner}()},
\code{\link{model_descriptor_to_module}()},
\code{\link{model_descriptor_union}()},
\code{\link{nn_graph}()}
}
\concept{Graph Network}
