% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingSpCVKnndm.R
\name{mlr_resamplings_spcv_knndm}
\alias{mlr_resamplings_spcv_knndm}
\alias{ResamplingSpCVKnndm}
\title{(CAST) K-fold Nearest Neighbour Distance Matching}
\description{
This function implements the kNNDM algorithm and returns the necessary
indices to perform a k-fold NNDM CV for map validation.
}
\details{
knndm is a k-fold version of NNDM LOO CV for medium and large datasets. Brielfy, the algorithm tries to
find a k-fold configuration such that the integral of the absolute differences (Wasserstein W statistic)
between the empirical nearest neighbour distance distribution function between the test and training data during CV (Gj*),
and the empirical nearest neighbour distance distribution function between the prediction and training points (Gij),
is minimised. It does so by performing clustering of the training points' coordinates for different numbers of
clusters that range from k to N (number of observations), merging them into k final folds,
and selecting the configuration with the lowest W.

Using a projected CRS in `knndm` has large computational advantages since fast nearest neighbour search can be
done via the `FNN` package, while working with geographic coordinates requires computing the full
spherical distance matrices. As a clustering algorithm, `kmeans` can only be used for
projected CRS while `hierarchical` can work with both projected and geographical coordinates, though it requires
calculating the full distance matrix of the training points even for a projected CRS.

In order to select between clustering algorithms and number of folds `k`, different `knndm` configurations can be run
and compared, being the one with a lower W statistic the one that offers a better match. W statistics between `knndm`
runs are comparable as long as `tpoints` and `predpoints` or `modeldomain` stay the same.

Map validation using `knndm` should be used using `CAST::global_validation`, i.e. by stacking all out-of-sample
predictions and evaluating them all at once. The reasons behind this are 1) The resulting folds can be
unbalanced and 2) nearest neighbour functions are constructed and matched using all CV folds simultaneously.

If training data points are very clustered with respect to the prediction area and the presented `knndm`
configuration still show signs of Gj* > Gij, there are several things that can be tried. First, increase
the `maxp` parameter; this may help to control for strong clustering (at the cost of having unbalanced folds).
Secondly, decrease the number of final folds `k`, which may help to have larger clusters.

The `modeldomain` is either a sf polygon that defines the prediction area, or alternatively a SpatRaster out of which a polygon,
transformed into the CRS of the training points, is defined as the outline of all non-NA cells.
Then, the function takes a regular point sample (amount defined by `samplesize`) from the spatial extent.
As an alternative use `predpoints` instead of `modeldomain`, if you have already defined the prediction locations (e.g. raster pixel centroids).
When using either `modeldomain` or `predpoints`, we advise to plot the study area polygon and the training/prediction points as a previous step to ensure they are aligned.

`knndm` can also be performed in the feature space by setting `space` to "feature".
Euclidean distances or Mahalanobis distances can be used for distance calculation, but only Euclidean are tested.
In this case, nearest neighbour distances are calculated in n-dimensional feature space rather than in geographical space.
`tpoints` and `predpoints` can be data frames or sf objects containing the values of the features. Note that the names of `tpoints` and `predpoints` must be the same.
`predpoints` can also be missing, if `modeldomain` is of class SpatRaster. In this case, the values of of the SpatRaster will be extracted to the `predpoints`.
In the case of any categorical features, Gower distances will be used to calculate the Nearest Neighbour distances [Experimental]. If categorical
features are present, and `clustering` = "kmeans", K-Prototype clustering will be performed instead.
}
\section{Parameters}{

\itemize{
\item \code{folds} (\code{integer(1)})\cr
Number of folds.
\item \code{stratify}\cr
If \code{TRUE}, stratify on the target column.
}
}

\examples{
if (mlr3misc::require_namespaces(c("sf", "CAST"), quietly = TRUE)) {
  library(mlr3)
  library(sf)

  set.seed(42)
  task = tsk("ecuador")
  points = sf::st_as_sf(task$coordinates(), crs = task$crs, coords = c("x", "y"))
  modeldomain = sf::st_as_sfc(sf::st_bbox(points))

  set.seed(42)
  cv_knndm = rsmp("spcv_knndm", modeldomain = modeldomain)
  cv_knndm$instantiate(task)

  #' ### Individual sets:
  # cv_knndm$train_set(1)
  # cv_knndm$test_set(1)
  # check that no obs are in both sets
  intersect(cv_knndm$train_set(1), cv_knndm$test_set(1)) # good!

  # Internal storage:
  # cv_knndm$instance # table
}
}
\references{
Linnenbrink, J., Mila, C., Ludwig, M., Meyer, H. (2023).
\dQuote{kNNDM: k-fold Nearest Neighbour Distance Matching Cross-Validation for map accuracy estimation.}
\emph{EGUsphere}, \bold{2023}, 1--16.
\doi{10.5194/egusphere-2023-1308}, \url{https://egusphere.copernicus.org/preprints/2023/egusphere-2023-1308/}.
}
\section{Super class}{
\code{\link[mlr3:Resampling]{mlr3::Resampling}} -> \code{ResamplingSpCVKnndm}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{iters}}{\code{integer(1)}\cr
Returns the number of resampling iterations, depending on the
values stored in the \code{param_set}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ResamplingSpCVKnndm-new}{\code{ResamplingSpCVKnndm$new()}}
\item \href{#method-ResamplingSpCVKnndm-instantiate}{\code{ResamplingSpCVKnndm$instantiate()}}
\item \href{#method-ResamplingSpCVKnndm-clone}{\code{ResamplingSpCVKnndm$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="format"><a href='../../mlr3/html/Resampling.html#method-Resampling-format'><code>mlr3::Resampling$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="help"><a href='../../mlr3/html/Resampling.html#method-Resampling-help'><code>mlr3::Resampling$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="print"><a href='../../mlr3/html/Resampling.html#method-Resampling-print'><code>mlr3::Resampling$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="test_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-test_set'><code>mlr3::Resampling$test_set()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="train_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-train_set'><code>mlr3::Resampling$train_set()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingSpCVKnndm-new"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingSpCVKnndm-new}{}}}
\subsection{Method \code{new()}}{
Create a "K-fold Nearest Neighbour Distance Matching" resampling instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingSpCVKnndm$new(id = "spcv_knndm")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character(1)}\cr
Identifier for the resampling strategy.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingSpCVKnndm-instantiate"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingSpCVKnndm-instantiate}{}}}
\subsection{Method \code{instantiate()}}{
Materializes fixed training and test splits for a given task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingSpCVKnndm$instantiate(task)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{\link{Task}\cr
A task to instantiate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingSpCVKnndm-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingSpCVKnndm-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingSpCVKnndm$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
