% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingRepeatedSpCVBlock.R
\name{mlr_resamplings_repeated_spcv_block}
\alias{mlr_resamplings_repeated_spcv_block}
\alias{ResamplingRepeatedSpCVBlock}
\title{(blockCV) Repeated spatial block resampling}
\description{
This function creates spatially separated folds based on a distance to number of row and/or column.
It assigns blocks to the training and testing folds \strong{randomly}, \strong{systematically} or
in a \strong{checkerboard pattern}. The distance (\code{size})
should be in \strong{metres}, regardless of the unit of the reference system of
the input data (for more information see the details section). By default,
the function creates blocks according to the extent and shape of the spatial sample data (\code{x} e.g.
the species occurrence), Alternatively, blocks can be created based on \code{r} assuming that the
user has considered the landscape for the given species and case study.
Blocks can also be offset so the origin is not at the outer corner of the rasters.
Instead of providing a distance, the blocks can also be created by specifying a number of rows and/or
columns and divide the study area into vertical or horizontal bins, as presented in Wenger & Olden (2012)
and Bahn & McGill (2012). Finally, the blocks can be specified by a user-defined spatial polygon layer.
}
\details{
To maintain consistency, all functions in this package use \strong{meters} as their unit of
measurement. However, when the input map has a geographic coordinate system (in decimal degrees),
the block size is calculated by dividing the \code{size} parameter by \code{deg_to_metre} (which
defaults to 111325 meters, the standard distance of one degree of latitude on the Equator).
In reality, this value varies by a factor of the cosine of the latitude. So, an alternative sensible
value could be \code{cos(mean(sf::st_bbox(x)[c(2,4)]) * pi/180) * 111325}.

The \code{offset} can be used to change the spatial position of the blocks. It can also be used to
assess the sensitivity of analysis results to shifting in the blocking arrangements.
These options are available when \code{size} is defined. By default the region is
located in the middle of the blocks and by setting the offsets, the blocks will shift.

Roberts et. al. (2017) suggest that blocks should be substantially bigger than the range of spatial
autocorrelation (in model residual) to obtain realistic error estimates, while a buffer with the size of
the spatial autocorrelation range would result in a good estimation of error. This is because of the so-called
edge effect (O'Sullivan & Unwin, 2014), whereby points located on the edges of the blocks of opposite sets are
not separated spatially. Blocking with a buffering strategy overcomes this issue (see \code{\link[blockCV]{cv_buffer}}).
}
\section{{mlr3spatiotempcv} notes}{


By default \code{\link[blockCV:cv_spatial]{blockCV::cv_spatial()}} does not allow the creation of multiple
repetitions. \code{mlr3spatiotempcv} adds support for this when using the \code{size}
argument for fold creation. When supplying a vector of \code{length(repeats)} for
argument \code{size}, these different settings will be used to create folds which
differ among the repetitions.

Multiple repetitions are not possible when using the "row & cols" approach
because the created folds will always be the same.

The 'Description' and 'Details' fields are inherited from the respective
upstream function.

For a list of available arguments, please see \link[blockCV:cv_spatial]{blockCV::cv_spatial}.

\code{blockCV} >= 3.0.0 changed the argument names of the implementation. For backward compatibility, \code{mlr3spatiotempcv} is still using the old ones.
Here's a list which shows the mapping between \code{blockCV} < 3.0.0 and \code{blockCV} >= 3.0.0:
\itemize{
\item \code{range} -> \code{size}
\item \code{rasterLayer} -> \code{r}
\item \code{speciesData} -> \code{points}
\item \code{showBlocks} -> \code{plot}
\item \code{cols} and \code{rows} -> \code{rows_cols}
}

The default of argument \code{hexagon} is different in \code{mlr3spatiotempcv} (\code{FALSE} instead of \code{TRUE}) to create square blocks instead of hexagonal blocks by default.
}

\section{Parameters}{

\itemize{
\item \code{repeats} (\code{integer(1)})\cr
Number of repeats.
}
}

\examples{
\dontrun{
if (mlr3misc::require_namespaces(c("sf", "blockCV"), quietly = TRUE)) {
  library(mlr3)
  task = tsk("diplodia")

  # Instantiate Resampling
  rrcv = rsmp("repeated_spcv_block",
    folds = 3, repeats = 2,
    range = c(5000L, 10000L))
  rrcv$instantiate(task)

  # Individual sets:
  rrcv$iters
  rrcv$folds(1:6)
  rrcv$repeats(1:6)

  # Individual sets:
  rrcv$train_set(1)
  rrcv$test_set(1)
  intersect(rrcv$train_set(1), rrcv$test_set(1))

  # Internal storage:
  rrcv$instance # table
}
}
}
\references{
Valavi R, Elith J, Lahoz-Monfort JJ, Guillera-Arroita G (2018).
\dQuote{blockCV: an R package for generating spatially or environmentally separated folds for k-fold cross-validation of species distribution models.}
\emph{bioRxiv}.
\doi{10.1101/357798}.
}
\section{Super class}{
\code{\link[mlr3:Resampling]{mlr3::Resampling}} -> \code{ResamplingRepeatedSpCVBlock}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{blocks}}{\verb{sf | list of sf objects}\cr
Polygons (\code{sf} objects) as returned by \pkg{blockCV} which grouped
observations into partitions.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{iters}}{\code{integer(1)}\cr
Returns the number of resampling iterations, depending on the
values stored in the \code{param_set}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ResamplingRepeatedSpCVBlock-new}{\code{ResamplingRepeatedSpCVBlock$new()}}
\item \href{#method-ResamplingRepeatedSpCVBlock-folds}{\code{ResamplingRepeatedSpCVBlock$folds()}}
\item \href{#method-ResamplingRepeatedSpCVBlock-repeats}{\code{ResamplingRepeatedSpCVBlock$repeats()}}
\item \href{#method-ResamplingRepeatedSpCVBlock-instantiate}{\code{ResamplingRepeatedSpCVBlock$instantiate()}}
\item \href{#method-ResamplingRepeatedSpCVBlock-clone}{\code{ResamplingRepeatedSpCVBlock$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="format"><a href='../../mlr3/html/Resampling.html#method-Resampling-format'><code>mlr3::Resampling$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="help"><a href='../../mlr3/html/Resampling.html#method-Resampling-help'><code>mlr3::Resampling$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="print"><a href='../../mlr3/html/Resampling.html#method-Resampling-print'><code>mlr3::Resampling$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="test_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-test_set'><code>mlr3::Resampling$test_set()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="train_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-train_set'><code>mlr3::Resampling$train_set()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSpCVBlock-new"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSpCVBlock-new}{}}}
\subsection{Method \code{new()}}{
Create an "spatial block" repeated resampling instance.

For a list of available arguments, please see \link[blockCV:cv_spatial]{blockCV::cv_spatial}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVBlock$new(id = "repeated_spcv_block")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character(1)}\cr
Identifier for the resampling strategy.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSpCVBlock-folds"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSpCVBlock-folds}{}}}
\subsection{Method \code{folds()}}{
Translates iteration numbers to fold number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVBlock$folds(iters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iters}}{\code{integer()}\cr
Iteration number.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSpCVBlock-repeats"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSpCVBlock-repeats}{}}}
\subsection{Method \code{repeats()}}{
Translates iteration numbers to repetition number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVBlock$repeats(iters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iters}}{\code{integer()}\cr
Iteration number.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSpCVBlock-instantiate"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSpCVBlock-instantiate}{}}}
\subsection{Method \code{instantiate()}}{
Materializes fixed training and test splits for a given task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVBlock$instantiate(task)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{\link{Task}\cr
A task to instantiate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSpCVBlock-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSpCVBlock-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVBlock$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
