% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvParametric.R
\name{LearnerSurvParametric}
\alias{LearnerSurvParametric}
\alias{mlr_learners_surv.parametric}
\title{Fully Parametric Survival Learner}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{LearnerSurv}.}
\description{
Calls \code{\link[survival:survreg]{survival::survreg()}}.
\itemize{
\item lp is predicted by using an internally defined \code{predict} method, see details
\item distr is predicted by using an internally defined \code{predict} method, see details
\item \code{crank} is identical to \code{lp}
}

This learner allows you to choose a distribution and a model form to compose a predicted
survival probability distribution. Note: Just because any combination of distribution and model
form is possible, this does not mean it will necessarily be sensible or interpretable.
}
\details{
The internal predict method is implemented in \code{mlr3proba}, which is more efficient for
composition to distributions than \code{\link[survival:predict.survreg]{survival::predict.survreg()}}.

\code{lp} is predicted using the formula \eqn{lp = X\beta} where \eqn{X} are the variables in the test
data set and \eqn{\beta} are the fitted coefficients.

The distribution \code{distr} is composed using the \code{lp} and specifying a model form in the
\code{type} hyper-parameter. These are as follows, with respective survival functions,
\itemize{
\item Accelerated Failure Time (\code{aft}) \deqn{S(t) = S_0(\frac{t}{exp(lp)})}{S(t) = S0(t/exp(lp))}
\item Proportional Hazards (\code{ph}) \deqn{S(t) = S_0(t)^{exp(lp)}}{S(t) = S0(t)^exp(lp)}
\item Proportional Odds (\code{po}) \deqn{S(t) = \frac{S_0(t)}{exp(-lp) + (1-exp(-lp)) S_0(t)}}{S(t) = S0(t) / [exp(-lp) + S0(t) (1-exp(-lp))]}
}

where \eqn{S_0}{S0} is the estimated baseline survival distribution (in this case
with a given parametric form), and \eqn{lp} is the predicted linear predictor.
}
\section{Construction}{
\preformatted{LearnerSurvParametric$new()
mlr_learners$get("surv.parametric")
lrn("surv.parametric")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \verb{distr, lp, crank}
\item Feature Types: \verb{logical, integer, numeric, factor}
\item Packages: \CRANpkg{survival} \CRANpkg{distr6} \CRANpkg{set6}
}
}

\references{
\cite{mlr3proba}{kalbfleisch_2002}
}
\seealso{
Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvCoxPH}},
\code{\link{LearnerSurvFlexible}},
\code{\link{LearnerSurvGBM}},
\code{\link{LearnerSurvGamboost}},
\code{\link{LearnerSurvGlmboost}},
\code{\link{LearnerSurvGlmnet}},
\code{\link{LearnerSurvKaplan}},
\code{\link{LearnerSurvMboost}},
\code{\link{LearnerSurvNelson}},
\code{\link{LearnerSurvObliqueRSF}},
\code{\link{LearnerSurvPenalized}},
\code{\link{LearnerSurvRandomForestSRC}},
\code{\link{LearnerSurvRanger}},
\code{\link{LearnerSurvRpart}},
\code{\link{LearnerSurvSVM}}
}
\concept{survival learners}
