% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvNelson.R
\name{LearnerSurvNelson}
\alias{LearnerSurvNelson}
\alias{mlr_learners_surv.nelson}
\title{Nelson-Aalen Estimator Survival Learner}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{LearnerSurv}.}
\description{
Calls \code{\link[survival:survfit]{survival::survfit()}}.
\itemize{
\item distr is predicted by estimating the cumulative hazard function with \code{\link[survival:survfit]{survival::survfit()}}
\item \code{crank} is predicted as the expectation of the survival distribution, \code{distr}
}
}
\section{Construction}{
\preformatted{LearnerSurvNelson$new()
mlr_learners$get("surv.nelson")
lrn("surv.nelson")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \verb{crank, distr}
\item Feature Types: \verb{logical, integer, numeric, character, factor, ordered}
\item Packages: \CRANpkg{survival} \CRANpkg{distr6}
}
}

\references{
Nelson, W. (1969).
Hazard plotting for incomplete failure data.
Journal of Quality Technology, 1, 27–52.
\doi{10.1080/00224065.1969.11980344}.

Nelson, W. (1972).
Theory and applications of hazard plotting for censored failure data.
Technometrics, 14, 945–965.
\doi{10.1080/00401706.1972.10488991}.

Aalen, Odd (1978).
Nonparametric inference for a family of counting processes.
Annals of Statistics, 6(4), 701–726.
}
\seealso{
Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvCoxPH}},
\code{\link{LearnerSurvFlexible}},
\code{\link{LearnerSurvGBM}},
\code{\link{LearnerSurvGamboost}},
\code{\link{LearnerSurvGlmboost}},
\code{\link{LearnerSurvGlmnet}},
\code{\link{LearnerSurvKaplan}},
\code{\link{LearnerSurvMboost}},
\code{\link{LearnerSurvParametric}},
\code{\link{LearnerSurvPenalized}},
\code{\link{LearnerSurvRandomForestSRC}},
\code{\link{LearnerSurvRanger}},
\code{\link{LearnerSurvRpart}},
\code{\link{LearnerSurvSVM}}
}
\concept{survival learners}
