% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpTuneThreshold.R
\name{mlr_pipeops_tunethreshold}
\alias{mlr_pipeops_tunethreshold}
\alias{PipeOpTuneThreshold}
\title{Tune the Threshold of a Classification Prediction}
\format{
\code{\link[R6:R6Class]{R6Class}} object inheriting from \code{\link{PipeOp}}.
}
\description{
Tunes optimal probability thresholds over different \code{\link[mlr3:PredictionClassif]{PredictionClassif}}s.

\code{\link[mlr3:Learner]{mlr3::Learner}} \code{predict_type}: \code{"prob"} is required.
Thresholds for each learner are optimized using the \code{\link[bbotk:Optimizer]{Optimizer}} supplied via
the \code{param_set}.
Defaults to \code{\link[GenSA:GenSA]{GenSA}}.
Returns a single \code{\link[mlr3:PredictionClassif]{PredictionClassif}}.

This PipeOp should be used in conjunction with \code{\link{PipeOpLearnerCV}} in order to
optimize thresholds of cross-validated predictions.
In order to optimize thresholds without cross-validation, use \code{\link{PipeOpLearnerCV}}
in conjunction with \code{\link[mlr3:mlr_resamplings_insample]{ResamplingInsample}}.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{* `PipeOpTuneThreshold$new(id = "tunethreshold", param_vals = list())` \\cr
  (`character(1)`, `list`) -> `self` \\cr
}\if{html}{\out{</div>}}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier of resulting object. Default: "tunethreshold".
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings
that would otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

Input and output channels are inherited from \code{\link{PipeOp}}.
}

\section{State}{

The \verb{$state} is a named \code{list} with elements
\itemize{
\item \code{thresholds} :: \code{numeric} learned thresholds
}
}

\section{Parameters}{

The parameters are the parameters inherited from \code{\link{PipeOp}}, as well as:
\itemize{
\item \code{measure} :: \code{\link[mlr3:Measure]{Measure}}  | \code{character}\cr
\code{\link[mlr3:Measure]{Measure}} to optimize for.
Will be converted to a \code{\link[mlr3:Measure]{Measure}} in case it is \code{character}.
Initialized to \code{"classif.ce"}, i.e. misclassification error.
\item \code{optimizer} :: \code{\link[bbotk:Optimizer]{Optimizer}}|\code{character(1)}\cr
\code{\link[bbotk:Optimizer]{Optimizer}} used to find optimal thresholds.
If \code{character}, converts to \code{\link[bbotk:Optimizer]{Optimizer}}
via \code{\link[bbotk:opt]{opt}}. Initialized to \code{OptimizerGenSA}.
\item \code{log_level} :: \code{character(1)} | \code{integer(1)}\cr
Set a temporary log-level for \code{lgr::get_logger("bbotk")}. Initialized to: "warn".
}
}

\section{Internals}{

Uses the \code{optimizer} provided as a \code{param_val} in order to find an optimal threshold.
See the \code{optimizer} parameter for more info.
}

\section{Methods}{

Only methods inherited from \code{\link{PipeOp}}.
}

\examples{
\dontshow{ if (requireNamespace("bbotk")) \{ }
\dontshow{ if (requireNamespace("rpart")) \{ }
\dontshow{ if (requireNamespace("GenSA")) \{ }
library("mlr3")

task = tsk("iris")
pop = po("learner_cv", lrn("classif.rpart", predict_type = "prob")) \%>>\%
  po("tunethreshold")

task$data()
pop$train(task)

pop$state
\dontshow{ \} }
\dontshow{ \} }
\dontshow{ \} }
}
\seealso{
https://mlr-org.com/pipeops.html

Other PipeOps: 
\code{\link{PipeOp}},
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{mlr_pipeops}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_colroles}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_datefeatures}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nmf}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_proxy}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomprojection}},
\code{\link{mlr_pipeops_randomresponse}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetinvert}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_vtreat}},
\code{\link{mlr_pipeops_yeojohnson}}
}
\concept{PipeOps}
