% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_graph.R
\name{as_pipeop}
\alias{as_pipeop}
\title{Conversion to mlr3pipeline PipeOp}
\usage{
as_pipeop(x, clone = FALSE)
}
\arguments{
\item{x}{(\code{any}) \cr
Object to convert.}

\item{clone}{(\code{logical(1)}) \cr
Whether to return a (deep copied) clone if \code{x} is a PipeOp.}
}
\value{
\code{\link{PipeOp}} \code{x} or a deep clone of it.
}
\description{
The argument is turned into a \code{\link{PipeOp}}
if possible.
If \code{clone} is \code{TRUE}, a deep copy is made
if the incoming object is a \code{\link{PipeOp}} to ensure the resulting
object is a different reference from the incoming object.

\code{\link[=as_pipeop]{as_pipeop()}} is an S3 method and can therefore be implemented by other packages
that may add objects that can naturally be converted to \code{\link{PipeOp}}s. Objects that
can be converted are for example \code{\link[mlr3:Learner]{Learner}} (using \code{\link{PipeOpLearner}}) or
\code{\link[mlr3filters:Filter]{Filter}} (using \code{\link{PipeOpFilter}}).
}
\seealso{
Other Graph operators: 
\code{\link{\%>>\%}()},
\code{\link{as_graph}()},
\code{\link{assert_graph}()},
\code{\link{assert_pipeop}()},
\code{\link{greplicate}()},
\code{\link{gunion}()},
\code{\link{pipeline_greplicate}()}
}
\concept{Graph operators}
