% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_graphs_elements.R
\name{mlr_graphs_bagging}
\alias{mlr_graphs_bagging}
\alias{pipeline_bagging}
\title{Create a bagging learner}
\usage{
pipeline_bagging(graph, iterations = 10, frac = 0.7, averager = NULL)
}
\arguments{
\item{graph}{\code{\link{PipeOp}} | \code{\link{Graph}} \cr
A \code{\link{PipeOpLearner}} or \code{\link{Graph}} to create a robustifying pipeline for.
Outputs from the replicated \code{graph}s are connected with the \code{averager}.}

\item{iterations}{\code{integer(1)} \cr
Number of bagging iterations. Defaults to 10.}

\item{frac}{\code{numeric(1)} \cr
Percentage of rows to keep during subsampling. See \code{\link{PipeOpSubsample}} for
more information. Defaults to 0.7.}

\item{averager}{\code{\link{PipeOp}} | \code{\link{Graph}} \cr
A \code{\link{PipeOp}} or \code{\link{Graph}} that averages the predictions from the
replicated and subsampled graph's.
In the simplest case, \code{po("classifavg")} and \code{po("regravg")} can be used
in order to perform simple averaging of classification and regression
predictions respectively.\code{If}NULL` (default), no averager is added to the end of the graph.}
}
\value{
\code{\link{Graph}}
}
\description{
Creates a \code{\link{Graph}} that performs bagging for a supplied graph.
This is done as follows:
\itemize{
\item \code{Subsample} the data in each step using \code{\link{PipeOpSubsample}}, afterwards apply \code{graph}.
\item Replicate this step \code{iterations} times (in parallel)
\item Average outputs of replicated \code{graph}s predictions using the \code{averager}.
}
}
\examples{
\donttest{
library(mlr3)
lrn_po = po("learner", lrn("regr.rpart"))
task = mlr_tasks$get("boston_housing")
gr = pipeline_bagging(lrn_po, 3, averager = po("regravg"))
resample(task, GraphLearner$new(gr), rsmp("holdout"))
}
}
