% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerAvg.R
\name{mlr_learners_avg}
\alias{mlr_learners_avg}
\alias{LearnerClassifAvg}
\alias{mlr_learners_classif.avg}
\alias{LearnerRegrAvg}
\alias{mlr_learners_regr.avg}
\title{Optimized Weighted Average of Features for Classification and Regression}
\format{
\code{\link{R6Class}} object inheriting from \code{\link[mlr3:LearnerClassif]{mlr3::LearnerClassif}}/\code{\link[mlr3:Learner]{mlr3::Learner}}.
}
\usage{
mlr_learners_classif.avg

mlr_learners_regr.avg
}
\description{
Computes a weighted average of inputs.
Used in the context of computing weighted averages of predictions.

Predictions are averaged using \code{weights} (in order of appearance in the data) which are optimized using
nonlinear optimization from the package "nloptr" for a measure provided in \code{measure} (defaults to \code{classif.acc}
for \code{LearnerClassifAvg} and \code{regr.mse} for \code{LearnerRegrAvg}).
Learned weights can be obtained from \verb{$model}.
Using non-linear optimization is implemented in the SuperLearner R package.
For a more detailed analysis the reader is referred to
\emph{LeDell, 2015: Scalable Ensemble Learning and Computationally Efficient Variance Estimation}.
}
\section{Parameter Set}{

\itemize{
\item \code{measure} :: \code{character(1)} | \code{Measure} \cr
Measure to optimized weights for.
The Measure is either obtained from \code{mlr_measures} or directly supplied. Defaults to \code{classif.acc}
for \code{LearnerClassifAvg} and \code{regr.mse} for \code{LearnerRegrAvg}
\item \code{algorithm} :: \code{character(1)} \cr
Several nonlinear optimization methods from \code{nloptr} are available.
See \code{nloptr::nloptr.print.options()} for a list of possible options.
Note that we only allow for derivative free local or global algorithms, i.e.
NLOPT_(G|L)N_.
}
}

\section{Methods}{

\itemize{
\item \verb{LearnerClassifAvg$new(), id = "classif.avg")} \cr
(\code{chr}) -> \code{self} \cr
Constructor.
\item \verb{LearnerRegrAvg$new(), id = "regr.avg")} \cr
(\code{chr}) -> \code{self} \cr
Constructor.
}
}

\seealso{
Other Learners: 
\code{\link{mlr_learners_graph}}

Other Ensembles: 
\code{\link{PipeOpEnsemble}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_regravg}}
}
\concept{Ensembles}
\concept{Learners}
