% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpMissingIndicators.R
\name{mlr_pipeops_missind}
\alias{mlr_pipeops_missind}
\alias{PipeOpMissInd}
\title{PipeOpMissInd}
\format{\code{\link{R6Class}} object inheriting from \code{\link{PipeOpTaskPreprocSimple}}/\code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.}
\description{
Add missing indicator columns ("dummy columns") to the \code{\link[mlr3:Task]{Task}}.
Drops original features; should probably be used in combination with \code{\link{PipeOpFeatureUnion}} and imputation \code{\link{PipeOp}}s (see examples).
}
\section{Construction}{
\preformatted{PipeOpMissInd$new(id = "missind", param_vals = list())
}
\itemize{
\item \code{id} :: \code{character(1)}
Identifier of the resulting  object, defaulting to \code{"missind"}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{State}{

\verb{$state} is a named \code{list} with the \verb{$state} elements inherited from \code{\link{PipeOpTaskPreproc}}, as well as:
\itemize{
\item \code{indicand_cols} :: \code{character}\cr
Names of columns for which indicator columns are added. If the \code{which} parameter is \code{"all"}, this is just the names of all features,
otherwise it is the names of all features that had missing values during training.
}
}

\section{Parameters}{

The parameters are the parameters inherited from the \code{\link{PipeOpTaskPreproc}}, as well as:
\itemize{
\item \code{which} :: \code{character(1)}\cr
Determines for which features the indicator columns are added. Can either be \code{"missing_train"} (default), adding indicator columns
for each feature that actually has missing values, or \code{"all"}, adding indicator columns for all features.
\item \code{type} :: \code{character(1)}\cr
Determines the type of the newly created columns. Can be one of \code{"numeric"}, \code{"factor"} (default), \code{"logical"}.
}
}

\section{Internals}{

This \code{\link{PipeOp}} should cover most cases where "dummy columns" or "missing indicators" are desired. Some edge cases:
\itemize{
\item If imputation
for factorial features is performed and only numeric features should gain missing indicators, the \code{affect_columns} parameter
can be set to \code{selector_type("numeric")}.
\item If missing indicators should only be added for features that have more than a fraction of \code{x} missing values, the
\code{\link{PipeOpRemoveConstants}} can be used with \code{affect_columns = selector_grep("^missing_")} and \code{ratio = x}.
}
}

\section{Fields}{

Fields inherited from \code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}

\section{Methods}{

Methods inherited from \code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}

\examples{
library("mlr3")

task = tsk("pima")$select(c("insulin", "triceps"))
sum(complete.cases(task$data()))
task$missings()
tail(task$data())

po = po("missind")
new_task = po$train(list(task))[[1]]

tail(new_task$data())

# proper imputation + missing indicators

impgraph = list(
  po("imputesample"),
  po("missind")
) \%>>\% po("featureunion")

tail(impgraph$train(task)[[1]]$data())
}
\seealso{
Other PipeOps: 
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOp}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputenewlvl}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_yeojohnson}},
\code{\link{mlr_pipeops}}
}
\concept{PipeOps}
