% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_private.R
\name{get_private}
\alias{get_private}
\title{Extract Private Fields of R6 Objects}
\usage{
get_private(x)
}
\arguments{
\item{x}{(\code{any})\cr
Object to extract the private members from.}
}
\value{
\code{environment()} of private members, or \code{NULL} if \code{x} is not an R6 object.
}
\description{
Provides access to the private members of \link[R6:R6Class]{R6::R6Class} objects.
}
\examples{
library(R6)
item = R6Class("Item", private = list(x = 1))$new()
get_private(item)$x
}
