% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity_phi.R
\name{phi}
\alias{phi}
\title{Phi Coefficient Similarity}
\usage{
phi(sets, p, na_value = NaN, ...)
}
\arguments{
\item{sets}{(\code{list()})\cr
List of character or integer vectors.
\code{sets} must have at least 2 elements.}

\item{p}{(\code{integer(1)})\cr
Total number of possible elements.}

\item{na_value}{(\code{numeric(1)})\cr
Value that should be returned if the measure is not defined for the input
(as described in the note). Default is \code{NaN}.}

\item{...}{(\code{any})\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Measure to compare two or more sets w.r.t. their similarity.
}
\details{
The Phi Coefficient is defined as the Pearson correlation between the binary
representation of two sets \eqn{A} and \eqn{B}.
The binary representation for \eqn{A} is a logical vector of
length \eqn{p} with the i-th element being 1 if the corresponding
element is in \eqn{A}, and 0 otherwise.

If more than two sets are provided, the mean of all pairwise scores
is calculated.

This measure is undefined if one set contains none or all possible elements.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"similarity"}
\item Range: \eqn{[-1, 1]}{[-1, 1]}
\item Minimize: \code{FALSE}
}
}

\examples{
set.seed(1)
sets = list(
  sample(letters[1:3], 1),
  sample(letters[1:3], 2)
)
phi(sets, p = 3)
}
\references{
Nogueira S, Brown G (2016).
\dQuote{Measuring the Stability of Feature Selection.}
In \emph{Machine Learning and Knowledge Discovery in Databases}, 442--457.
Springer International Publishing.
\doi{10.1007/978-3-319-46227-1_28}.

Bommert A, Rahnenführer J, Lang M (2017).
\dQuote{A Multicriteria Approach to Find Predictive and Sparse Models with Stable Feature Selection for High-Dimensional Data.}
\emph{Computational and Mathematical Methods in Medicine}, \bold{2017}, 1--18.
\doi{10.1155/2017/7907163}.

Bommert A, Lang M (2021).
\dQuote{stabm: Stability Measures for Feature Selection.}
\emph{Journal of Open Source Software}, \bold{6}(59), 3010.
\doi{10.21105/joss.03010}.
}
\seealso{
Package \CRANpkg{stabm} which implements many more stability measures with included
correction for chance.

Other Similarity Measures: 
\code{\link{jaccard}()}
}
\concept{Similarity Measures}
\concept{similarity_measure}
