% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classif_ce.R
\name{ce}
\alias{ce}
\title{Classification Error}
\usage{
ce(truth, response, ...)
}
\arguments{
\item{truth}{:: \code{factor()}\cr
True (observed) labels.
Must have the same levels and length as \code{response}.}

\item{response}{:: \code{factor()}\cr
Predicted response labels.
Must have the same levels and length as \code{truth}.}

\item{...}{:: \code{any}\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Classification measure defined as \deqn{
  \frac{1}{n} \sum_{i=1}^n \left( t_i \neq r_i \right).
}{
  mean(t != r).
}
}
\section{Meta Information}{

\itemize{
\item Type: \code{"classif"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{TRUE}
\item Required prediction: \code{response}
}
}

\examples{
set.seed(1)
lvls = c("a", "b", "c")
truth = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
response = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
ce(truth, response)
}
\seealso{
Other Classification Measures: 
\code{\link{acc}()},
\code{\link{bacc}()},
\code{\link{logloss}()}
}
\concept{Classification Measures}
\concept{classification_measure}
