% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResultAssignerArchive.R
\name{mlr_result_assigners_archive}
\alias{mlr_result_assigners_archive}
\alias{ResultAssignerArchive}
\title{Result Assigner Based on the Archive}
\description{
Result assigner that chooses the final point(s) based on all evaluations in the \link[bbotk:Archive]{bbotk::Archive}.
This mimics the default behavior of any \link[bbotk:Optimizer]{bbotk::Optimizer}.
}
\examples{
result_assigner = ras("archive")
}
\seealso{
Other Result Assigner: 
\code{\link{ResultAssigner}},
\code{\link{mlr_result_assigners}},
\code{\link{mlr_result_assigners_surrogate}}
}
\concept{Result Assigner}
\section{Super class}{
\code{\link[mlr3mbo:ResultAssigner]{mlr3mbo::ResultAssigner}} -> \code{ResultAssignerArchive}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{packages}}{(\code{character()})\cr
Set of required packages.
A warning is signaled if at least one of the packages is not installed, but loaded (not attached) later on-demand via \code{\link[=requireNamespace]{requireNamespace()}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ResultAssignerArchive-new}{\code{ResultAssignerArchive$new()}}
\item \href{#method-ResultAssignerArchive-assign_result}{\code{ResultAssignerArchive$assign_result()}}
\item \href{#method-ResultAssignerArchive-clone}{\code{ResultAssignerArchive$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="ResultAssigner" data-id="format"><a href='../../mlr3mbo/html/ResultAssigner.html#method-ResultAssigner-format'><code>mlr3mbo::ResultAssigner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="ResultAssigner" data-id="print"><a href='../../mlr3mbo/html/ResultAssigner.html#method-ResultAssigner-print'><code>mlr3mbo::ResultAssigner$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultAssignerArchive-new"></a>}}
\if{latex}{\out{\hypertarget{method-ResultAssignerArchive-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultAssignerArchive$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultAssignerArchive-assign_result"></a>}}
\if{latex}{\out{\hypertarget{method-ResultAssignerArchive-assign_result}{}}}
\subsection{Method \code{assign_result()}}{
Assigns the result, i.e., the final point(s) to the instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultAssignerArchive$assign_result(instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{(\link[bbotk:OptimInstanceSingleCrit]{bbotk::OptimInstanceSingleCrit} | \link[bbotk:OptimInstanceMultiCrit]{bbotk::OptimInstanceMultiCrit})\cr
The \link[bbotk:OptimInstance]{bbotk::OptimInstance} the final result should be assigned to.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResultAssignerArchive-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ResultAssignerArchive-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResultAssignerArchive$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
