% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerRegrKKNN.R
\name{mlr_learners_regr.kknn}
\alias{mlr_learners_regr.kknn}
\alias{LearnerRegrKKNN}
\title{k-Nearest-Neighbor Regression Learner}
\description{
k-Nearest-Neighbor regression.
Calls \code{\link[kknn:kknn]{kknn::kknn()}} from package \CRANpkg{kknn}.
}
\note{
There is no training step for k-NN models, just storing the training data to
process it during the predict step.
Therefore, \verb{$model} returns a list with the following elements:
\itemize{
\item \code{formula}: Formula for calling \code{\link[kknn:kknn]{kknn::kknn()}} during \verb{$predict()}.
\item \code{data}: Training data for calling \code{\link[kknn:kknn]{kknn::kknn()}} during \verb{$predict()}.
\item \code{pv}: Training parameters for calling \code{\link[kknn:kknn]{kknn::kknn()}} during \verb{$predict()}.
\item \code{kknn}: Model as returned by \code{\link[kknn:kknn]{kknn::kknn()}}, only available \strong{after} \verb{$predict()} has been called.
}
}
\section{Dictionary}{

This \link{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_learners} or with the associated sugar function \code{\link[=lrn]{lrn()}}:\preformatted{mlr_learners$get("regr.kknn")
lrn("regr.kknn")
}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{regr}
\item Predict Types: \dQuote{response}
\item Feature Types: \dQuote{logical}, \dQuote{integer}, \dQuote{numeric}, \dQuote{factor}, \dQuote{ordered}
\item Required Packages: \CRANpkg{mlr3}, \CRANpkg{mlr3learners}, \CRANpkg{kknn}
}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Range \tab Levels \cr
   k \tab integer \tab 7 \tab \eqn{[1, \infty)}{[1, Inf)} \tab - \cr
   distance \tab numeric \tab 2 \tab \eqn{[0, \infty)}{[0, Inf)} \tab - \cr
   kernel \tab character \tab optimal \tab - \tab rectangular, triangular, epanechnikov, biweight, triweight, cos, inv, gaussian, rank, optimal \cr
   scale \tab logical \tab TRUE \tab - \tab TRUE, FALSE \cr
   ykernel \tab list \tab NULL \tab - \tab - \cr
}
}

\examples{
if (requireNamespace("kknn", quietly = TRUE)) {
  learner = mlr3::lrn("regr.kknn")
  print(learner)

  # available parameters:
learner$param_set$ids()
}
}
\references{
Hechenbichler, Klaus, Schliep, Klaus (2004).
\dQuote{Weighted k-nearest-neighbor techniques and ordinal classification.}
Technical Report Discussion Paper 399, SFB 386, Ludwig-Maximilians University Munich.
\doi{10.5282/ubm/epub.1769}.

Samworth, J R (2012).
\dQuote{Optimal weighted nearest neighbour classifiers.}
\emph{The Annals of Statistics}, \bold{40}(5), 2733--2763.
\doi{10.1214/12-AOS1049}.

Cover, Thomas, Hart, Peter (1967).
\dQuote{Nearest neighbor pattern classification.}
\emph{IEEE transactions on information theory}, \bold{13}(1), 21--27.
\doi{10.1109/TIT.1967.1053964}.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/basics.html#learners}
\item Package \href{https://github.com/mlr-org/mlr3extralearners}{mlr3extralearners} for more learners.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Learner]{Learners}: \link{mlr_learners}
\item \code{as.data.table(mlr_learners)} for a table of available \link[=Learner]{Learners} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3pipelines} to combine learners with pre- and postprocessing steps.
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
\item \CRANpkg{mlr3tuning} for tuning of hyperparameters, \CRANpkg{mlr3tuningspaces}
for established default tuning spaces.
}

Other Learner: 
\code{\link{mlr_learners_classif.cv_glmnet}},
\code{\link{mlr_learners_classif.glmnet}},
\code{\link{mlr_learners_classif.kknn}},
\code{\link{mlr_learners_classif.lda}},
\code{\link{mlr_learners_classif.log_reg}},
\code{\link{mlr_learners_classif.multinom}},
\code{\link{mlr_learners_classif.naive_bayes}},
\code{\link{mlr_learners_classif.nnet}},
\code{\link{mlr_learners_classif.qda}},
\code{\link{mlr_learners_classif.ranger}},
\code{\link{mlr_learners_classif.svm}},
\code{\link{mlr_learners_classif.xgboost}},
\code{\link{mlr_learners_regr.cv_glmnet}},
\code{\link{mlr_learners_regr.glmnet}},
\code{\link{mlr_learners_regr.km}},
\code{\link{mlr_learners_regr.lm}},
\code{\link{mlr_learners_regr.ranger}},
\code{\link{mlr_learners_regr.svm}},
\code{\link{mlr_learners_regr.xgboost}},
\code{\link{mlr_learners_surv.cv_glmnet}},
\code{\link{mlr_learners_surv.glmnet}},
\code{\link{mlr_learners_surv.ranger}},
\code{\link{mlr_learners_surv.xgboost}}
}
\concept{Learner}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}} -> \code{LearnerRegrKKNN}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{LearnerRegrKKNN$new()}}
\item \href{#method-clone}{\code{LearnerRegrKKNN$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner">}\href{../../mlr3/html/Learner.html#method-base_learner}{\code{mlr3::Learner$base_learner()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format">}\href{../../mlr3/html/Learner.html#method-format}{\code{mlr3::Learner$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help">}\href{../../mlr3/html/Learner.html#method-help}{\code{mlr3::Learner$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict">}\href{../../mlr3/html/Learner.html#method-predict}{\code{mlr3::Learner$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata">}\href{../../mlr3/html/Learner.html#method-predict_newdata}{\code{mlr3::Learner$predict_newdata()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print">}\href{../../mlr3/html/Learner.html#method-print}{\code{mlr3::Learner$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset">}\href{../../mlr3/html/Learner.html#method-reset}{\code{mlr3::Learner$reset()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train">}\href{../../mlr3/html/Learner.html#method-train}{\code{mlr3::Learner$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrKKNN$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrKKNN$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
