% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TunerSuccessiveHalving.R
\name{mlr_tuners_successive_halving}
\alias{mlr_tuners_successive_halving}
\alias{TunerSuccessiveHalving}
\title{Hyperparameter Tuning with Successive Halving}
\source{
Jamieson K, Talwalkar A (2016).
\dQuote{Non-stochastic Best Arm Identification and Hyperparameter Optimization.}
In Gretton A, Robert CC (eds.), \emph{Proceedings of the 19th International Conference on Artificial Intelligence and Statistics}, volume 51 series Proceedings of Machine Learning Research, 240-248.
\url{http://proceedings.mlr.press/v51/jamieson16.html}.
}
\description{
\code{TunerSuccessiveHalving} class that implements the successive halving
algorithm. The algorithm samples \code{n} configurations and evaluates them with
the smallest budget (lower bound of the \code{budget} parameter). With every stage
the budget is increased by a factor of \code{eta} and only the best \code{1/eta}
configurations are promoted to the next stage. The optimization terminates
when the maximum budget is reached (upper bound of the \code{budget} parameter)

To identify the budget, the user has to specify explicitly which parameter of
the objective function influences the budget by tagging a single parameter in
in the search_space (\link[paradox:ParamSet]{paradox::ParamSet}) with \code{"budget"}.
}
\section{Parameters}{

\describe{
\item{\code{n}}{\code{integer(1)}\cr
Number of configurations in first stage.}
\item{\code{eta}}{\code{numeric(1)}\cr
With every stage, the configuration budget is increased by a factor of \code{eta}
and only the best \code{1/eta} configurations are used for the next stage.
Non-integer values are supported, but \code{eta} is not allowed to be less or
equal 1.}
\item{\code{sampler}}{\link[paradox:Sampler]{paradox::Sampler}\cr
Object defining how the samples of the parameter space should be drawn during
the initialization of each bracket. The default is uniform sampling.}
}
}

\section{Archive}{

The \link[mlr3tuning:ArchiveTuning]{mlr3tuning::ArchiveTuning} holds the following additional column that is specific
to the successive halving algorithm:
\itemize{
\item \code{stage} (\verb{integer(1))}\cr
Stage index. Starts counting at 0.
}
}

\examples{
if(requireNamespace("xgboost")) {
library(mlr3learners)

# define hyperparameter and budget parameter
search_space = ps(
  nrounds = p_int(lower = 1, upper = 16, tags = "budget"),
  eta = p_dbl(lower = 0, upper = 1),
  booster = p_fct(levels = c("gbtree", "gblinear", "dart"))
)

\donttest{
# hyperparameter tuning on the pima indians diabetes data set
instance = tune(
  method = "successive_halving",
  task = tsk("pima"),
  learner = lrn("classif.xgboost", eval_metric = "logloss"),
  resampling = rsmp("cv", folds = 3),
  measures = msr("classif.ce"),
  search_space = search_space
)

# best performing hyperparameter configuration
instance$result
}
}
}
\section{Super classes}{
\code{\link[mlr3tuning:Tuner]{mlr3tuning::Tuner}} -> \code{\link[mlr3tuning:TunerFromOptimizer]{mlr3tuning::TunerFromOptimizer}} -> \code{TunerSuccessiveHalving}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{TunerSuccessiveHalving$new()}}
\item \href{#method-clone}{\code{TunerSuccessiveHalving$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="format">}\href{../../mlr3tuning/html/Tuner.html#method-format}{\code{mlr3tuning::Tuner$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="print">}\href{../../mlr3tuning/html/Tuner.html#method-print}{\code{mlr3tuning::Tuner$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3tuning" data-topic="TunerFromOptimizer" data-id="optimize">}\href{../../mlr3tuning/html/TunerFromOptimizer.html#method-optimize}{\code{mlr3tuning::TunerFromOptimizer$optimize()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerSuccessiveHalving$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerSuccessiveHalving$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
