% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_fselectors.R
\docType{data}
\name{mlr_fselectors}
\alias{mlr_fselectors}
\title{Dictionary of FSelectors}
\format{
\link[R6:R6Class]{R6::R6Class} object inheriting from \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}.
}
\description{
A \link[mlr3misc:Dictionary]{mlr3misc::Dictionary} storing objects of class \link{FSelector}.
Each fselector has an associated help page, see \code{mlr_fselectors_[id]}.

For a more convenient way to retrieve and construct fselectors, see \code{\link[=fs]{fs()}}/\code{\link[=fss]{fss()}}.
}
\section{Methods}{

See \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}.
}

\section{S3 methods}{

\itemize{
\item \code{as.data.table(dict, ..., objects = FALSE)}\cr
\link[mlr3misc:Dictionary]{mlr3misc::Dictionary} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a \code{\link[data.table:data.table]{data.table::data.table()}} with fields "key", "label", "properties" and "packages" as columns.
If \code{objects} is set to \code{TRUE}, the constructed objects are returned in the list column named \code{object}.
}
}

\examples{
as.data.table(mlr_fselectors)
mlr_fselectors$get("random_search")
fs("random_search")
}
\seealso{
Sugar functions: \code{\link[=fs]{fs()}}, \code{\link[=fss]{fss()}}
}
\concept{Dictionary}
\concept{FSelector}
\keyword{datasets}
