% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSelectorDesignPoints.R
\name{FSelectorDesignPoints}
\alias{FSelectorDesignPoints}
\title{Feature Selection via Design Points}
\description{
\code{FSelectorDesignPoints} class that implements feature selection w.r.t. fixed
feature sets.  We simply search over a set of feature subsets fully specified
by the user. The feature sets are evaluated in order as given.

In order to support general termination criteria and parallelization, we
evaluate feature sets in a batch-fashion of size \code{batch_size}. Larger
batches mean we can parallelize more, smaller batches imply a more
fine-grained checking of termination criteria.
}
\section{Dictionary}{

This \link{FSelector} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_fselectors} or with the associated sugar function \code{\link[=fs]{fs()}}:\preformatted{mlr_fselectors$get("design_points")
fs("design_points")
}
}

\section{Parameters}{


\describe{
\item{\code{batch_size}}{\code{integer(1)}\cr
Maximum number of configurations to try in a batch.}
\item{\code{design}}{\link[data.table:data.table]{data.table::data.table}\cr
Design points to try in search, one per row.}
}

}

\examples{
library(mlr3)
library(data.table)

terminator = trm("evals", n_evals = 10)

instance = FSelectInstanceSingleCrit$new(
  task = tsk("iris"),
  learner = lrn("classif.rpart"),
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  terminator = terminator
)

design = data.table(Petal.Length = c(TRUE, FALSE),
  Petal.Width = c(TRUE, FALSE),
  Sepal.Length = c(FALSE, TRUE),
  Sepal.Width = c(FALSE, TRUE))

fselector = fs("design_points", design = design)
\donttest{
# Modifies the instance by reference
fselector$optimize(instance)

# Returns best scoring evaluation
instance$result

# Allows access of data.table of full path of all evaluations
instance$archive$data()}
}
\section{Super classes}{
\code{\link[mlr3fselect:FSelector]{mlr3fselect::FSelector}} -> \code{\link[mlr3fselect:FSelectorFromOptimizer]{mlr3fselect::FSelectorFromOptimizer}} -> \code{FSelectorDesignPoints}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FSelectorDesignPoints$new()}}
\item \href{#method-clone}{\code{FSelectorDesignPoints$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="format">}\href{../../mlr3fselect/html/FSelector.html#method-format}{\code{mlr3fselect::FSelector$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="print">}\href{../../mlr3fselect/html/FSelector.html#method-print}{\code{mlr3fselect::FSelector$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelectorFromOptimizer" data-id="optimize">}\href{../../mlr3fselect/html/FSelectorFromOptimizer.html#method-optimize}{\code{mlr3fselect::FSelectorFromOptimizer$optimize()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorDesignPoints$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorDesignPoints$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
