% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpFDASmooth.R
\name{mlr_pipeops_fda.smooth}
\alias{mlr_pipeops_fda.smooth}
\alias{PipeOpFDASmooth}
\title{Smoothing Functional Columns}
\description{
Smoothes functional data using \code{\link[tf:tf_smooth]{tf::tf_smooth()}}.
This preprocessing operator is similar to \code{\link{PipeOpFDAInterpol}}, however it does not interpolate to unobserved
x-values, but rather smooths the observed values.
}
\section{Parameters}{

The parameters are the parameters inherited from \code{\link{PipeOpTaskPreprocSimple}}, as well as the following
parameters:
\itemize{
\item \code{method} :: \code{character(1)}\cr
One of:
\itemize{
\item "lowess": locally weighted scatterplot smoothing (default)
\item "rollmean": rolling mean
\item "rollmedian": rolling meadian
\item "savgol":  Savitzky-Golay filtering
}

All methods but "lowess" ignore non-equidistant arg values.
\item \code{args} :: named \code{list()}\cr
List of named arguments that is passed to \code{tf_smooth()}. See the help page of \code{tf_smooth()} for
default values.
\item \code{verbose} :: \code{logical(1)}\cr
Whether to print messages during the transformation.
Is initialized to \code{FALSE}.
}
}

\examples{
library(mlr3pipelines)

task = tsk("fuel")
po_smooth = po("fda.smooth", method = "rollmean", args = list(k = 5))
task_smooth = po_smooth$train(list(task))[[1L]]
task_smooth
task_smooth$data(cols = c("NIR", "UVVIS"))
}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpTaskPreproc]{mlr3pipelines::PipeOpTaskPreproc}} -> \code{\link[mlr3pipelines:PipeOpTaskPreprocSimple]{mlr3pipelines::PipeOpTaskPreprocSimple}} -> \code{PipeOpFDASmooth}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpFDASmooth-new}{\code{PipeOpFDASmooth$new()}}
\item \href{#method-PipeOpFDASmooth-clone}{\code{PipeOpFDASmooth$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFDASmooth-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFDASmooth-new}{}}}
\subsection{Method \code{new()}}{
Initializes a new instance of this Class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFDASmooth$new(id = "fda.smooth", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of resulting object, default \code{"fda.smooth"}.}

\item{\code{param_vals}}{(named \code{list})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction. Default \code{list()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFDASmooth-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFDASmooth-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFDASmooth$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
