% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerClustBIRCH.R
\name{mlr_learners_clust.birch}
\alias{mlr_learners_clust.birch}
\alias{LearnerClustBIRCH}
\title{BIRCH Clustering Learner}
\description{
BIRCH (Balanced Iterative Reducing Clustering using Hierarchies) clustering.
Calls \code{\link[stream:DSC_BIRCH]{stream::DSC_BIRCH()}} from \CRANpkg{stream}.
}
\section{Dictionary}{

This \link[mlr3:Learner]{mlr3::Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link[mlr3:mlr_learners]{mlr3::mlr_learners} or with the associated sugar function \code{\link[mlr3:mlr_sugar]{mlr3::lrn()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_learners$get("clust.birch")
lrn("clust.birch")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{clust}
\item Predict Types: \dQuote{partition}
\item Feature Types: \dQuote{integer}, \dQuote{numeric}
\item Required Packages: \CRANpkg{mlr3}, \CRANpkg{mlr3cluster}, \CRANpkg{stream}
}
}

\section{Parameters}{
\tabular{llll}{
   Id \tab Type \tab Default \tab Range \cr
   threshold \tab numeric \tab - \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   branching \tab integer \tab - \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   maxLeaf \tab integer \tab - \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   maxMem \tab integer \tab 0 \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   outlierThreshold \tab numeric \tab 0.25 \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
}
}

\examples{
if (requireNamespace("stream")) {
  learner = mlr3::lrn("clust.birch")
  print(learner)

  # available parameters:
  learner$param_set$ids()
}
}
\references{
Zhang, Tian, Ramakrishnan, Raghu, Livny, Miron (1996).
\dQuote{BIRCH: An Efficient Data Clustering Method for Very Large Databases.}
\emph{ACM sigmod record}, \bold{25}(2), 103--114.

Zhang, Tian, Ramakrishnan, Raghu, Livny, Miron (1997).
\dQuote{BIRCH: A new data clustering algorithm and its applications.}
\emph{Data Mining and Knowledge Discovery}, \bold{1}, 141--182.

Hahsler M, Bolaños M, Forrest J (2017).
\dQuote{Introduction to stream: An Extensible Framework for Data Stream Clustering Research with R.}
\emph{Journal of Statistical Software}, \bold{76}(14), 1--50.
\doi{10.18637/jss.v076.i14}.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/chapters/chapter2/data_and_basic_modeling.html#sec-learners}
\item Package \href{https://github.com/mlr-org/mlr3extralearners}{mlr3extralearners} for more learners.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[mlr3:Learner]{Learners}: \link[mlr3:mlr_learners]{mlr3::mlr_learners}
\item \code{as.data.table(mlr_learners)} for a table of available \link[mlr3:Learner]{Learners} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3pipelines} to combine learners with pre- and postprocessing steps.
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
\item \CRANpkg{mlr3tuning} for tuning of hyperparameters, \CRANpkg{mlr3tuningspaces}
for established default tuning spaces.
}

Other Learner: 
\code{\link{mlr_learners_clust.MBatchKMeans}},
\code{\link{mlr_learners_clust.SimpleKMeans}},
\code{\link{mlr_learners_clust.agnes}},
\code{\link{mlr_learners_clust.ap}},
\code{\link{mlr_learners_clust.bico}},
\code{\link{mlr_learners_clust.cmeans}},
\code{\link{mlr_learners_clust.cobweb}},
\code{\link{mlr_learners_clust.dbscan}},
\code{\link{mlr_learners_clust.dbscan_fpc}},
\code{\link{mlr_learners_clust.diana}},
\code{\link{mlr_learners_clust.em}},
\code{\link{mlr_learners_clust.fanny}},
\code{\link{mlr_learners_clust.featureless}},
\code{\link{mlr_learners_clust.ff}},
\code{\link{mlr_learners_clust.hclust}},
\code{\link{mlr_learners_clust.hdbscan}},
\code{\link{mlr_learners_clust.kkmeans}},
\code{\link{mlr_learners_clust.kmeans}},
\code{\link{mlr_learners_clust.mclust}},
\code{\link{mlr_learners_clust.meanshift}},
\code{\link{mlr_learners_clust.optics}},
\code{\link{mlr_learners_clust.pam}},
\code{\link{mlr_learners_clust.xmeans}}
}
\concept{Learner}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3cluster:LearnerClust]{mlr3cluster::LearnerClust}} -> \code{LearnerClustBIRCH}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerClustBIRCH-new}{\code{LearnerClustBIRCH$new()}}
\item \href{#method-LearnerClustBIRCH-clone}{\code{LearnerClustBIRCH$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="encapsulate"><a href='../../mlr3/html/Learner.html#method-Learner-encapsulate'><code>mlr3::Learner$encapsulate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3cluster" data-topic="LearnerClust" data-id="reset"><a href='../../mlr3cluster/html/LearnerClust.html#method-LearnerClust-reset'><code>mlr3cluster::LearnerClust$reset()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClustBIRCH-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClustBIRCH-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClustBIRCH$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClustBIRCH-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClustBIRCH-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClustBIRCH$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
