hashes = function(x) {
  map_chr(unname(x), "hash")
}

hash = function(...) {
  dots = list(...)
  is_fun = map_lgl(dots, is.function)
  dots[is_fun] = map(dots[is_fun], function(fun) {
    list(formals = formals(fun), body = as.character(body(fun)))
  })
  digest::digest(dots, algo = "xxhash64")
}

# updating join:
# replaces values in x with values in y
ujoin = function(x, y, key) {
  cn = setdiff(intersect(names(x), names(y)), key)
  expr = parse(text = paste0("`:=`(", paste0(sprintf("%1$s=i.%1$s", cn), collapse = ","), ")"))
  x[y, eval(expr), on = key][]
}

translate_types = function(x) {
  r_types = mlr_reflections$task_feature_types
  p_types = names(mlr_reflections$task_feature_types)
  factor(map_values(x, r_types, p_types), levels = p_types)
}

allow_partial_matching = list(
  warnPartialMatchArgs = FALSE,
  warnPartialMatchAttr = FALSE,
  warnPartialMatchDollar = FALSE
)


replace_with = function(x, needle, replacement) {
  ii = (x == needle)
  x = rep(x, 1L + (length(replacement) - 1L) * ii)
  replace(x, ii, replacement)
}

# extract values from a single column of a data table
# tries hard to avoid the overhead of data.table for small tables
fget = function(tab, i, j, key = key(tab)) {
  if (nrow(tab) > 1000L) {
    tab[list(i), j, on = key, with = FALSE][[1L]]
  } else {
    table = tab[[key]]
    if (is.character(table)) {
      tab[[j]][chmatch(i, table, nomatch = 0L)]
    } else {
      tab[[j]][match(i, table, nomatch = 0L)]
    }
  }
}
