% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_task_regr.R
\name{as_task_regr}
\alias{as_task_regr}
\alias{as_task_regr.TaskRegr}
\alias{as_task_regr.data.frame}
\alias{as_task_regr.matrix}
\alias{as_task_regr.Matrix}
\alias{as_task_regr.DataBackend}
\alias{as_task_regr.TaskClassif}
\alias{as_task_regr.formula}
\title{Convert to a Regression Task}
\usage{
as_task_regr(x, ...)

\method{as_task_regr}{TaskRegr}(x, clone = FALSE, ...)

\method{as_task_regr}{data.frame}(
  x,
  target = NULL,
  id = deparse(substitute(x)),
  label = NA_character_,
  ...
)

\method{as_task_regr}{matrix}(
  x,
  target = NULL,
  id = deparse(substitute(x)),
  label = NA_character_,
  ...
)

\method{as_task_regr}{Matrix}(
  x,
  target = NULL,
  id = deparse(substitute(x)),
  label = NA_character_,
  ...
)

\method{as_task_regr}{DataBackend}(
  x,
  target = NULL,
  id = deparse(substitute(x)),
  label = NA_character_,
  ...
)

\method{as_task_regr}{TaskClassif}(
  x,
  target = NULL,
  drop_original_target = FALSE,
  drop_levels = TRUE,
  ...
)

\method{as_task_regr}{formula}(
  x,
  data,
  id = deparse(substitute(data)),
  label = NA_character_,
  ...
)
}
\arguments{
\item{x}{(any)\cr
Object to convert.}

\item{...}{(any)\cr
Additional arguments.}

\item{clone}{(\code{logical(1)})\cr
If \code{TRUE}, ensures that the returned object is not the same as the input \code{x}.}

\item{target}{(\code{character(1)})\cr
Name of the target column.}

\item{id}{(\code{character(1)})\cr
Id for the new task.
Defaults to the (deparsed and substituted) name of the data argument.}

\item{label}{(\code{character(1)})\cr
Label for the new instance.}

\item{drop_original_target}{(\code{logical(1)})\cr
If \code{FALSE} (default), the original target is added as a feature.
Otherwise the original target is dropped.}

\item{drop_levels}{(\code{logical(1)})\cr
If \code{TRUE} (default), unused levels of the new target variable are dropped.}

\item{data}{(\code{data.frame()})\cr
Data frame containing all columns referenced in formula \code{x}.}
}
\value{
\link{TaskRegr}.
}
\description{
Convert object to a \link{TaskRegr}.
This is a S3 generic. mlr3 ships with methods for the following objects:
\enumerate{
\item \link{TaskRegr}: ensure the identity
\item \code{\link{formula}}, \code{\link[=data.frame]{data.frame()}}, \code{\link[=matrix]{matrix()}}, \code{\link[Matrix:Matrix]{Matrix::Matrix()}} and \link{DataBackend}: provides an alternative to the constructor of \link{TaskRegr}.
\item \link{TaskClassif}: Calls \code{\link[=convert_task]{convert_task()}}.
}
}
\examples{
as_task_regr(datasets::mtcars, target = "mpg")
}
