% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerClassif.R
\name{LearnerClassif}
\alias{LearnerClassif}
\title{Classification Learner}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link{Learner}.}
\description{
This Learner specializes \link{Learner} for classification problems.

Many predefined learners can be found in the \link[mlr3misc:Dictionary]{mlr3misc::Dictionary} \link{mlr_learners} after loading the \CRANpkg{mlr3learners} package.
}
\section{Construction}{
\preformatted{l = LearnerClassif$new(id, param_set = ParamSet$new(), predict_types = character(), feature_types = character(),
    properties = character(), data_formats = "data.table", packages = character(), man = NA_character_)
}

For a description of the arguments, see \link{Learner}.
\code{task_type} is set to \code{"classif"}.

Possible values for \code{predict_types} are passed to and converted by \link{PredictionClassif}:
\itemize{
\item \code{"response"}: Predicts a class label for each observation in the test set.
\item \code{"prob"}: Predicts the posterior probability for each class for each observation in the test set.
}

Additional learner properties include:
\itemize{
\item \code{"twoclass"}: The learner works on binary classification problems.
\item \code{"multiclass"}: The learner works on multiclass classification problems.
}
}

\section{Fields}{

See \link{Learner}.
}

\section{Methods}{

See \link{Learner}.
}

\examples{
# get all classification learners from mlr_learners:
lrns = mlr_learners$mget(mlr_learners$keys("^classif"))
names(lrns)

# get a specific learner from mlr_learners:
lrn = lrn("classif.rpart")
print(lrn)

# train the learner:
task = tsk("iris")
lrn$train(task, 1:120)

# predict on new observations:
lrn$predict(task, 121:150)$confusion
}
\seealso{
Example classification learners: \code{\link[=mlr_learners_classif.rpart]{classif.rpart}}

Other Learner: 
\code{\link{LearnerRegr}},
\code{\link{Learner}},
\code{\link{mlr_learners}}
}
\concept{Learner}
