% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSelectedFeatures.R
\name{mlr_measures_selected_features}
\alias{mlr_measures_selected_features}
\alias{MeasureSelectedFeatures}
\title{Selected Features Measure}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{Measure}.}
\description{
Measures the number of selected features by extracting it from learners with property \code{"selected_features"}.
If the learner does not support this, \code{NA} is returned.

This measure requires the \link{Task} and the \link{Learner} for scoring.
}
\section{Construction}{
\preformatted{MeasureSelectedFeatures$new(normalize = FALSE)
mlr_measures$get("selected_features")
msr("selected_features")
}
\itemize{
\item \code{normalize} :: \code{logical(1)}\cr
If \code{normalize} is set to \code{TRUE}, divides the number of features by the total number of features.
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{NA}
\item Range: \eqn{[0, \infty)}{[0, Inf)}
\item Minimize: \code{TRUE}
\item Required prediction: 'response'
}
}

\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Measure]{Measures}: \link{mlr_measures}

\code{as.data.table(mlr_measures)} for a complete table of all (also dynamically created) \link{Measure} implementations.
}
