% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataBackendDataTable.R
\docType{data}
\name{DataBackendDataTable}
\alias{DataBackendDataTable}
\title{DataBackend for data.table}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link{DataBackend}.}
\description{
\link{DataBackend} for \CRANpkg{data.table} as an in-memory data base.
}
\section{Construction}{
\preformatted{DataBackendDataTable$new(data, primary_key = NULL)
as_data_backend(data, primary_key = NULL, ...)
}
\itemize{
\item \code{data} :: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
The input \code{\link[data.table:data.table]{data.table::data.table()}}.
\item \code{primary_key} :: \code{character(1)}\cr
Name of the primary key column.
}

\code{DataBackendDataTable} does not copy the input data, while \code{as_data_backend} calls \code{\link[data.table:copy]{data.table::copy()}}.
\code{as_data_backend} creates a primary key column as integer column if \code{primary_key} is \code{NULL.}
}

\section{Fields}{

See \link{DataBackend}.
}

\section{Methods}{

See \link{DataBackend}.
}

\examples{
data = as.data.table(iris)
data$id = seq_len(nrow(iris))
b = DataBackendDataTable$new(data = data, primary_key = "id")
print(b)
b$head()
b$data(rows = 100:101, cols = "Species")

b$nrow
head(b$rownames)

b$ncol
b$colnames

# alternative construction
as_data_backend(iris)
}
\seealso{
Other DataBackend: \code{\link{DataBackendMatrix}},
  \code{\link{DataBackend}}, \code{\link{as_data_backend}}
}
\concept{DataBackend}
\keyword{datasets}
