% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Measure.R
\docType{data}
\name{Measure}
\alias{Measure}
\title{Measure Class}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
This is the abstract base class for measures like \link{MeasureClassif} and \link{MeasureRegr}.

Measures are classes around tailored around two functions:
\enumerate{
\item A function \code{score} which quantifies the performance by comparing true and predicted response.
\item A function \code{aggregator} which combines multiple performance values returned by
\code{calculate} to a single numeric value.
}

In addition to these two functions, meta-information about the performance measure is stored.

Predefined measures are stored in the \link{Dictionary} \link{mlr_measures},
e.g. \code{\link[=mlr_measures_classif.auc]{classif.auc}} or \code{\link[=mlr_measures_time_train]{time_train}}.
A guide on how to extend \CRANpkg{mlr3} with custom measures can be found in the \href{https://mlr3book.mlr-org.com}{mlr3book}.
}
\section{Construction}{

Note: This object is typically constructed via a derived classes, e.g. \link{MeasureClassif} or \link{MeasureRegr}.\preformatted{m = Measure$new(id, task_type, range, minimize, predict_type = "response",
     task_properties = character(), na_score = FALSE, packages = character())
}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier for the measure.
\item \code{task_type} :: \code{character(1)}\cr
Type of the task the measure can operator on. E.g., \code{"classif"} or \code{"regr"}.
\item \code{range} :: \code{numeric(2)}\cr
Feasible range for this measure as \code{c(lower_bound, upper_bound)}.
Both bounds may be infinite.
\item \code{minimize} :: \code{logical(1)}\cr
Set to \code{TRUE} if good predictions correspond to small values,
and to \code{FALSE} if good predictions correspond to large values.
If set to \code{NA}, tuning with this measure is not possible.
\item \code{aggregator} :: \code{function(x)}\cr
Function to aggregate individual performance values \code{x} where \code{x} is a numeric vector.
If \code{NULL}, defaults to \code{\link[=mean]{mean()}}.
\item \code{predict_type} :: \code{character(1)}\cr
Required predict type of the \link{Learner}.
Possible values are stored in \link[=mlr_reflections]{mlr_reflections$learner_predict_types}.
\item \code{task_properties} :: \code{character()}\cr
Required task properties, see \link{Task}.
\item \code{na_score} :: \code{logical(1)}\cr
Is the measure expected to return \code{NA} in some cases? Default is \code{FALSE}.
\item \code{packages} :: \code{character()}\cr
Set of required packages.
Note that these packages will be loaded via \code{\link[=requireNamespace]{requireNamespace()}}, and are not attached.
}
}

\section{Fields}{

\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier of the measure.
\item \code{minimize} :: \code{logical(1)}\cr
Is \code{TRUE} if the best value is reached via minimization and \code{FALSE} by maximization.
\item \code{packages} :: \code{character()}\cr
Stores the names of required packages.
\item \code{range} :: \code{numeric(2)}\cr
Stores the feasible range of the measure.
\item \code{task_type} :: \code{character(1)}\cr
Stores the required type of the \link{Task}.
\item \code{task_properties} :: \code{character()}\cr
Stores required properties of the \link{Task}.
}
}

\section{Methods}{

\itemize{
\item \code{aggregate(rr)}\cr
\link{ResampleResult} -> \code{numeric(1)}\cr
Aggregates multiple performance scores into a single score using the \code{aggregator} function of the measure.
Operates on a \link{ResampleResult} as returned by \link{resample}.
\item \code{score(prediction, task = NULL, learner = NULL)}\cr
(\link{Prediction}, \link{Task}, \link{Learner}) -> \code{numeric(1)}\cr
Takes a \link{Prediction} and calculates a numeric score.
If the measure if flagged with the properties \code{"requires_task"} or \code{"requires_learner"}, you must additionally
pass the respective \link{Task} or the \link{Learner} for the measure to extract information from these objects.
}
}

\seealso{
Other Measure: \code{\link{MeasureClassif}},
  \code{\link{MeasureRegr}}, \code{\link{mlr_measures}}
}
\concept{Measure}
\keyword{datasets}
