% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.R
\docType{data}
\name{measures}
\alias{G1}
\alias{G2}
\alias{acc}
\alias{arsq}
\alias{auc}
\alias{bac}
\alias{ber}
\alias{brier}
\alias{brier.scaled}
\alias{cindex}
\alias{db}
\alias{dunn}
\alias{expvar}
\alias{f1}
\alias{fdr}
\alias{featperc}
\alias{fn}
\alias{fnr}
\alias{fp}
\alias{fpr}
\alias{gmean}
\alias{gpr}
\alias{logloss}
\alias{mae}
\alias{mcc}
\alias{mcp}
\alias{meancosts}
\alias{measureACC}
\alias{measureAU1P}
\alias{measureAU1U}
\alias{measureAUC}
\alias{measureAUNP}
\alias{measureAUNU}
\alias{measureBAC}
\alias{measureBrier}
\alias{measureBrierScaled}
\alias{measureEXPVAR}
\alias{measureFDR}
\alias{measureFN}
\alias{measureFNR}
\alias{measureFP}
\alias{measureFPR}
\alias{measureGMEAN}
\alias{measureGPR}
\alias{measureLogloss}
\alias{measureMAE}
\alias{measureMCC}
\alias{measureMEDAE}
\alias{measureMEDSE}
\alias{measureMMCE}
\alias{measureMSE}
\alias{measureMultiLabelF1}
\alias{measureMulticlassBrier}
\alias{measureMultilabelACC}
\alias{measureMultilabelHamloss}
\alias{measureMultilabelPPV}
\alias{measureMultilabelSubset01}
\alias{measureMultilabelTPR}
\alias{measureNPV}
\alias{measurePPV}
\alias{measureRMSE}
\alias{measureRSQ}
\alias{measureSAE}
\alias{measureSSE}
\alias{measureTN}
\alias{measureTNR}
\alias{measureTP}
\alias{measureTPR}
\alias{measures}
\alias{medae}
\alias{medse}
\alias{mmce}
\alias{mse}
\alias{multiclass.au1p}
\alias{multiclass.au1u}
\alias{multiclass.aunp}
\alias{multiclass.aunu}
\alias{multiclass.brier}
\alias{multilabel.acc}
\alias{multilabel.f1}
\alias{multilabel.hamloss}
\alias{multilabel.ppv}
\alias{multilabel.subset01}
\alias{multilabel.tpr}
\alias{npv}
\alias{ppv}
\alias{rmse}
\alias{rsq}
\alias{sae}
\alias{silhouette}
\alias{sse}
\alias{timeboth}
\alias{timepredict}
\alias{timetrain}
\alias{tn}
\alias{tnr}
\alias{tp}
\alias{tpr}
\title{Performance measures.}
\format{none}
\usage{
featperc

timetrain

timepredict

timeboth

sse

measureSSE(truth, response)

mse

measureMSE(truth, response)

rmse

measureRMSE(truth, response)

medse

measureMEDSE(truth, response)

sae

measureSAE(truth, response)

mae

measureMAE(truth, response)

medae

measureMEDAE(truth, response)

rsq

measureRSQ(truth, response)

expvar

measureEXPVAR(truth, response)

arsq

mmce

measureMMCE(truth, response)

acc

measureACC(truth, response)

ber

multiclass.aunu

measureAUNU(probabilities, truth)

multiclass.aunp

measureAUNP(probabilities, truth)

multiclass.au1u

measureAU1U(probabilities, truth)

multiclass.au1p

measureAU1P(probabilities, truth)

multiclass.brier

measureMulticlassBrier(probabilities, truth)

logloss

measureLogloss(probabilities, truth)

auc

measureAUC(probabilities, truth, negative, positive)

brier

measureBrier(probabilities, truth, negative, positive)

brier.scaled

measureBrierScaled(probabilities, truth, negative, positive)

bac

measureBAC(truth, response, negative, positive)

tp

measureTP(truth, response, positive)

tn

measureTN(truth, response, negative)

fp

measureFP(truth, response, positive)

fn

measureFN(truth, response, negative)

tpr

measureTPR(truth, response, positive)

tnr

measureTNR(truth, response, negative)

fpr

measureFPR(truth, response, negative, positive)

fnr

measureFNR(truth, response, negative, positive)

ppv

measurePPV(truth, response, positive)

npv

measureNPV(truth, response, negative)

fdr

measureFDR(truth, response, positive)

mcc

measureMCC(truth, response, negative, positive)

f1

gmean

measureGMEAN(truth, response, negative, positive)

gpr

measureGPR(truth, response, positive)

multilabel.hamloss

measureMultilabelHamloss(truth, response)

multilabel.subset01

measureMultilabelSubset01(truth, response)

multilabel.f1

measureMultiLabelF1(truth, response)

multilabel.acc

measureMultilabelACC(truth, response)

multilabel.ppv

measureMultilabelPPV(truth, response)

multilabel.tpr

measureMultilabelTPR(truth, response)

cindex

meancosts

mcp

db

dunn

G1

G2

silhouette
}
\arguments{
\item{truth}{[\code{factor}]\cr
Vector of the true class.}

\item{response}{[\code{factor}]\cr
Vector of the predicted class.}

\item{probabilities}{[\code{numeric} | \code{matrix}]\cr
a) For purely binary classification measures: The predicted probabilities for the positive class as a numeric vector.
b) For multiclass classification measures: The predicted probabilities for all classes, always as a numeric matrix, where
columns are named with class labels.}

\item{negative}{[\code{character(1)}]\cr
The name of the negative class.}

\item{positive}{[\code{character(1)}]\cr
The name of the positive class.}
}
\description{
A performance measure is evaluated after a single train/predict step and returns a single number to assess the quality
of the prediction (or maybe only the model, think AIC).
The measure itself knows whether it wants to be minimized or maximized and for what tasks it is applicable.

All supported measures can be found by \code{\link{listMeasures}} or as a table
in the tutorial appendix: \url{http://mlr-org.github.io/mlr-tutorial/release/html/measures/}.

If you want a measure for a misclassification cost matrix, look at \code{\link{makeCostMeasure}}.
If you want to implement your own measure, look at \code{\link{makeMeasure}}.

Most measures can directly be accessed via the function named after the scheme measureX (e.g. measureSSE).

For clustering measures, we compact the predicted cluster IDs such that they form a continuous series
starting with 1. If this is not the case, some of the measures will generate warnings.
}
\references{
He, H. & Garcia, E. A. (2009)
\emph{Learning from Imbalanced Data.}
IEEE Transactions on Knowledge and Data Engineering, vol. 21, no. 9. pp. 1263-1284.
}
\seealso{
Other performance: \code{\link{estimateRelativeOverfitting}},
  \code{\link{makeCostMeasure}},
  \code{\link{makeCustomResampledMeasure}},
  \code{\link{makeMeasure}}, \code{\link{performance}}
}
\keyword{datasets}

