#' Iris classification task
#'
#' Contains the task (\code{iris.task}).
#'
#' @name iris.task
#' @references See \code{\link[datasets]{iris}}.
#' @keywords data
#' @docType data
NULL

#' Sonar classification task
#'
#' Contains the task (\code{sonar.task}).
#'
#' @name sonar.task
#' @references See \code{\link[mlbench]{Sonar}}.
#' @keywords data
#' @docType data
NULL

#' Wisconsin Breast Cancer classification task
#'
#' Contains the task (\code{bc.task}).
#'
#' @name bc.task
#' @references See \code{\link[mlbench]{BreastCancer}}.
#'   The column \code{"Id"} and all incomplete cases have been removed from the task.
#' @keywords data
#' @docType data
NULL

#' PimaIndiansDiabetes classification task
#'
#' Contains the task (\code{pid.task}).
#'
#' @name pid.task
#' @references See \code{\link[mlbench]{PimaIndiansDiabetes}}.
#'   Note that this is the uncorrected version from mlbench.
#' @keywords data
#' @docType data
NULL

#' Boston Housing regression task
#'
#' Contains the task (\code{bh.task}).
#'
#' @name bh.task
#' @aliases bh.task
#' @references See \code{\link[mlbench]{BostonHousing}}.
#' @keywords data
#' @docType data
NULL

#' Wisonsin Prognostic Breast Cancer (WPBC) survival task
#'
#' Contains the task (\code{wpbc.task}).
#'
#' @name wpbc.task
#' @aliases wpbc.task
#' @references See \code{\link[TH.data]{wpbc}}.
#'  Incomplete cases have been removed from the task.
#' @keywords data
#' @docType data
NULL

#' NCCTG Lung Cancer survival task
#'
#' Contains the task (\code{lung.task}).
#'
#' @name lung.task
#' @aliases lung.task
#' @references See \code{\link[survival]{lung}}.
#'  Incomplete cases have been removed from the task.
#' @keywords data
#' @docType data
NULL

#' Motor Trend Car Road Tests clustering task
#'
#' Contains the task (\code{mtcars.task}).
#'
#' @name mtcars.task
#' @aliases mtcars.task
#' @references See \code{\link[datasets]{mtcars}}.
#' @keywords data
#' @docType data
NULL

#' European Union Agricultural Workforces clustering task
#'
#' Contains the task (\code{agri.task}).
#'
#' @name agri.task
#' @aliases agri.task
#' @references See \code{\link[cluster]{agriculture}}.
#' @keywords data
#' @docType data
NULL

#' Iris cost-sensitive classification task
#'
#' Contains the task (\code{costiris.task}).
#'
#' @name costiris.task
#' @aliases costiris.task
#' @references See \code{\link[datasets]{iris}}.
#'   The cost matrix was generated artificially following
#'
#'   Tu, H.-H. and Lin, H.-T. (2010), One-sided support vector regression for multiclass cost-sensitive classification.
#'   In ICML, J. Fürnkranz and T. Joachims, Eds., Omnipress, 1095--1102.
#' @keywords data
#' @docType data
NULL

#' Yeast multilabel classification task
#'
#' Contains the task (\code{yeast.task}).
#'
#' @name yeast.task
#' @source \url{http://sourceforge.net/projects/mulan/files/datasets/yeast.rar}
#' @references Elisseeff, A., & Weston, J. (2001):
#' A kernel method for multi-labelled classification.
#' In Advances in neural information processing systems (pp. 681-687).
#' @keywords data
#' @docType data
NULL
