% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/generateThreshVsPerf.R
\name{plotThreshVsPerf}
\alias{plotThreshVsPerf}
\title{Plot threshold vs. performance(s) for 2-class classification using ggplot2.}
\usage{
plotThreshVsPerf(obj, facet = "measure", mark.th = NA_real_)
}
\arguments{
\item{obj}{[\code{ThreshVsPerfData}]\cr
Result of \code{\link{generateThreshVsPerfData}}.}

\item{facet}{[\code{character(1)}]\cr
Selects \dQuote{measure} or \dQuote{learner} to be the facetting variable.
The variable mapped to \code{facet} must have more than one unique value, otherwise it will
be ignored. The variable not chosen is mapped to color if it has more than one unique value.
The default is \dQuote{measure}.}

\item{mark.th}{[\code{numeric(1)}]\cr
Mark given threshold with vertical line?
Default is \code{NA} which means not to do it.}
}
\value{
ggplot2 plot object.
}
\description{
Plot threshold vs. performance(s) for 2-class classification using ggplot2.
}
\examples{
lrn = makeLearner("classif.rpart", predict.type = "prob")
mod = train(lrn, sonar.task)
pred = predict(mod, sonar.task)
pvs = generateThreshVsPerfData(pred, list(tpr, fpr))
plotThreshVsPerf(pvs)
}
\seealso{
Other plot: \code{\link{plotFilterValuesGGVIS}};
  \code{\link{plotFilterValues}};
  \code{\link{plotLearningCurveGGVIS}};
  \code{\link{plotLearningCurve}};
  \code{\link{plotROCRCurvesGGVIS}};
  \code{\link{plotROCRCurves}};
  \code{\link{plotThreshVsPerfGGVIS}}

Other thresh_vs_perf: \code{\link{generateThreshVsPerfData}};
  \code{\link{plotThreshVsPerfGGVIS}}
}

